//#include "functions/detail_mapping.function"


//detail(secondary) albedo和albedo纹理采样
#SHADER_DEFINE AlbedoSamplingWithDetail

    FUNCTION_INPUT =
    {
				{ TEXTURE_ALDEBO,						NONE,			TEXTURE2D,		"albedoMap" },
				{ TEXTURE_DETAIL_ALDEBO,				NONE,			TEXTURE2D,		"detailAlbedoMap" },
				{ TEXTURE_DETAIL_MASK,					NONE,			TEXTURE2D,		"detailMask" },
				{ ATTRIBUTE_COORDNATE0,					MEDIUM,			VEC2,			"in_Coordinate" },
    }

    FUNCTION_OUTPUT =
    {
				{ ALBEDO_COLOR,							LOW,			VEC3,			"albedo" },
				{ DETAIL_ALBEDO_COLOR,					LOW,			VEC3,			"detailAlbedo" },
				{ DETAIL_MASK_VALUE,					MEDIUM,			FLOAT,			"mask" },
    }

#SHADER_CODE
	vec3 albedo = texture2D(albedoMap, in_Coordinate).rgb;
	vec3 detailAlbedo = texture2D(detailAlbedoMap, in_Coordinate).rgb;
	float mask = texture2D(detailMask, in_Coordinate).r;
#END_CODE
#END_DEFINE


//albedo混合模式：lerp
#SHADER_DEFINE AlbedoBlendingLerp

    FUNCTION_INPUT =
    {
				{ ALBEDO_COLOR,							LOW,			VEC3,				"albedo" },
				{ DETAIL_ALBEDO_COLOR,					LOW,			VEC3,				"detailAlbedo" },
				{ DETAIL_MASK_VALUE,					MEDIUM,			FLOAT,				"mask" },
    }

    FUNCTION_OUTPUT =
    {
				 { ALBEDO_COLOR,						LOW,			VEC3,				"albedoColor" },
    }

#SHADER_CODE
	vec3 albedoColor = mix(albedo, detailAlbedo, mask);
#END_CODE
#END_DEFINE

//albedo混合模式：add
#SHADER_DEFINE AlbedoBlendingAdd

    FUNCTION_INPUT =
    {
				{ ALBEDO_COLOR,							LOW,			VEC3,				"albedo" },
				{ DETAIL_ALBEDO_COLOR,					LOW,			VEC3,				"detailAlbedo" },
				{ DETAIL_MASK_VALUE,					MEDIUM,			FLOAT,				"mask" },
    }

    FUNCTION_OUTPUT =
    {
				 { ALBEDO_COLOR,						LOW,			VEC3,				"albedoColor" },
    }

#SHADER_CODE
	vec3 albedoColor = albedo + detailAlbedo * mask;
#END_CODE
#END_DEFINE

//albedo输出
#SHADER_DEFINE AlbedoFragmentOutput

    FUNCTION_INPUT =
    {
		{ ALBEDO_COLOR,			LOW,		VEC3,			"albedoColor" },
    }

    FUNCTION_OUTPUT =
    {
    }

#SHADER_CODE

	gl_FragColor = vec4(albedoColor, 1.0);

#END_CODE
#END_DEFINE

//Normal Map和Deteail(secondary) Normal Map的融合
#SHADER_DEFINE NormalBlendingWithDetail

    FUNCTION_INPUT =
    {
				{ ATTRIBUTE_COORDNATE0,			MEDIUM,		VEC2,			"in_Coordinate" },
				{ TEXTURE_NORMAL,				NONE,		TEXTURE2D,		"normalMap" },
				{ TEXTURE_DETAIL_MASK,			NONE,		TEXTURE2D,		"detailMask" },
				{ TEXTURE_DETAIL_NORMAL,		NONE,		TEXTURE2D,		"detailNormalMap" },
    }

    FUNCTION_OUTPUT =
    {
				{ TANGENTSPACE_NORMAL,			LOW,		VEC3,			"normal" },
    }

#SHADER_CODE

	float mask = texture2D(detailMask, in_Coordinate).r;
	vec3 baseNormal = texture2D(normalMap, in_Coordinate).xyz;
	vec3 detailNormal = texture2D(detailNormalMap, in_Coordinate).xyz;
	//vec3 normal = blend_rnm(baseNormal, detailNormal);
	vec3 normal;
	{
		vec3 n1 = baseNormal;
		vec3 n2 = detailNormal;
		vec3 t = n1.xyz*vec3( 2.0,  2.0, 2.0) + vec3(-1.0, -1.0,  0.0);
		vec3 u = n2.xyz*vec3(-2.0, -2.0, 2.0) + vec3( 1.0,  1.0, -1.0);
		vec3 r = t*dot(t, u) - u*t.z;
		normal = normalize(r);
	}
	normal = mix(baseNormal, normal, mask);
#END_CODE
#END_DEFINE



//法线输出
#SHADER_DEFINE NormalFragmentOutput

    FUNCTION_INPUT =
    {
		{ TANGENTSPACE_NORMAL,			LOW,		VEC3,			"normal" },
    }

    FUNCTION_OUTPUT =
    {
    }

#SHADER_CODE

	gl_FragColor = vec4(normal * 0.5 + 0.5, 1.0);

#END_CODE
#END_DEFINE