
#DEFPARAMS
_MaxDistance = { "reflection distance", FLOAT, "8"},
_Resolution = { "screen step percentage", FLOAT, "0.3" },
_Thickness = { "thickness", FLOAT, "0.5" }
#END
   
   
#DEFTAG
ShaderName = "ray_marching"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
#include "lightdeferred.inc"

float _MaxDistance;
float _Resolution;
float _Thickness;
float _RefinedSteps;

Texture2D TEXTURE_GBUFFER_A;
Texture2D TEXTURE_FWD_MASK;
Texture2D TEXTURE_GBUFFER_DEPTH;

SamplerState TEXTURE_GBUFFER_A_SAMPLER;
SamplerState TEXTURE_FWD_MASK_SAMPLER;
SamplerState TEXTURE_GBUFFER_DEPTH_SAMPLER;

float2 texSize;

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f input, out float4 outColor : SV_Target0)
{
   float2 TexCoords = input.uv;
   float4 mask = TEXTURE_FWD_MASK.Sample(TEXTURE_FWD_MASK_SAMPLER, TexCoords);
   if(mask.r > 0.9)
   { 
	 outColor = float4(0.0,0.0,0.0,0.0);
	 return;
   }
   
   float4 data0 = TEXTURE_GBUFFER_A.Sample(TEXTURE_GBUFFER_A_SAMPLER, TexCoords);
   float metallic = data0.w;
 
   
   float depthView = TEXTURE_GBUFFER_DEPTH.Sample(TEXTURE_GBUFFER_DEPTH_SAMPLER, TexCoords).r;
   if (  depthView > 0.9999 ) { 
	 outColor = float4(0.0,0.0,0.0,0.0); 
	 return;
   }
   
   float3 worldPos = WorldPosFromDepth(2.0 * depthView - 1.0, input.uv);
   float4 viewPos = mul(float4(worldPos, 1.0), CAMERA_VIEW);
   float3 hitCoord = viewPos.xyz / viewPos.w;
   

   float3 worldNormal = data0.xyz;//DecodeNormal(data0.xy);
   worldNormal = worldNormal * 2.0 - float3(1.0, 1.0, 1.0);
   //float3x3 _TransInvView = transpose(float3x3(mul(CAMERA_PROJECTION , CAMERA_VIEWPROJ_INV)));
   float3x3 camera = float3x3(CAMERA_VIEW[0].xyz,CAMERA_VIEW[1].xyz,CAMERA_VIEW[2].xyz);
   float3 viewNormal = normalize(mul(worldNormal, camera).xyz);
   //outColor = float4(viewNormal,1.0); return; 
   // Reflection vector
   float3 reflected = normalize(reflect(normalize(hitCoord), viewNormal));
 
   
   float3 dir = normalize(reflected);
   


  float4 startView = float4(hitCoord.xyz, 1.0);
  float4 endView   = float4(hitCoord.xyz + (dir * _MaxDistance), 1.0);


  float3 uv = float3(0.0,0.0,0.0);

  float4 startFrag      = startView;
       startFrag      = UniformNDC(mul(startFrag, CAMERA_PROJECTION ));
       startFrag.xyz /= startFrag.w;
       startFrag.xyz   = startFrag.xyz * 0.5 + 0.5;
 #if SHADER_TARGET_HLSL
	   startFrag.y = 1.0 - startFrag.y;
#endif
       startFrag.xy  *= texSize;


  float4 endFrag      = endView;
       endFrag      = UniformNDC(mul(endFrag, CAMERA_PROJECTION ));
       endFrag.xyz /= endFrag.w;
       endFrag.xyz   = endFrag.xyz * 0.5 + 0.5;
 #if SHADER_TARGET_HLSL
	   endFrag.y = 1.0 - endFrag.y;
#endif
       endFrag.xy  *= texSize;


  float2 frag  = startFrag.xy;
  uv.xy = frag / texSize;

  float deltaX    = endFrag.x - startFrag.x;
  float deltaY    = endFrag.y - startFrag.y;
  float useX      = abs(deltaX) >= abs(deltaY) ? 1.0 : 0.0;
  float delta     = lerp(abs(deltaY), abs(deltaX), useX) * clamp(_Resolution, 0.0, 1.0);
  float2  increment = float2(deltaX, deltaY) / max(delta, 0.001);

  float search0 = 0;
  float search1 = 0;

  int hit0 = 0;
  int hit1 = 0;

  float viewDistance = startView.z;
  float depth        = _Thickness;

  float3 positionFrom = hitCoord;
  float3 positionTo = positionFrom;
  
  int i;
  #if SHADER_TARGET_HLSL
  [loop]
  #endif
  for (i = 0; i < int(delta); i+= 1) {
	frag += increment;	
	if(frag.x >= texSize.x || frag.x <= 0.0 || frag.y >= texSize.y || frag.y <= 0.0)
		break;
    uv.xy      = frag / texSize;

    float z = TEXTURE_GBUFFER_DEPTH.Sample(TEXTURE_GBUFFER_DEPTH_SAMPLER, uv.xy).r;  
	
	if(	z  > 0.9999 )
		continue;
	
	positionTo = ViewPosFromDepth(z, uv.xy);
		
    search1 =
      lerp
        ( (frag.y - startFrag.y) / deltaY
        , (frag.x - startFrag.x) / deltaX
        , useX
        );

    search1 = clamp(search1, 0.0, 1.0);

	viewDistance = (startView.z * endView.z) / lerp(endView.z, startView.z, search1);
    depth        = viewDistance - positionTo.z;

    if (depth <= 0.0 && depth > -_Thickness) 
	{
      hit0 = 1;
     break;
    } else {
      search0 = search1;
    }
  } 

  int step = _RefinedSteps * hit0;
  search1 = search0 + ((search1 - search0) / 2.0);
  float2 lastUv = uv.xy ;
  float3 lastPointTo = positionTo;
  float lastDepth = depth;
  #if SHADER_TARGET_HLSL
  [loop]
  #endif
  for (i = 0; i < step; ++i) {
    frag       = lerp(startFrag.xy, endFrag.xy, search1);
    uv.xy      = frag / texSize;

    float z = TEXTURE_GBUFFER_DEPTH.Sample(TEXTURE_GBUFFER_DEPTH_SAMPLER, uv.xy).r;  	
	positionTo = ViewPosFromDepth(z , uv.xy);
	
    viewDistance = (startView.z * endView.z) / lerp(endView.z, startView.z, search1);
    depth        = viewDistance - positionTo.z;

    if (depth <= 0 && depth > -_Thickness)  
	{
      hit1 = 1;
      search1 = search0 + ((search1 - search0) / 2);
	  lastUv = uv.xy;
	  lastPointTo = positionTo;
	  lastDepth = depth;
    } else {
      float temp = search1;
      search1 = search1 + ((search1 - search0) / 2);
      search0 = temp;
    }
  }

 // if(hit1 == 1)
  {
	uv.xy = lastUv;
	positionTo = lastPointTo;
	depth = lastDepth;
  }
   float visibility =
      hit0
    * ( 1
      - max
         ( dot(-normalize(positionFrom.xyz), dir)
         , 0
         )
      )
    * ( 1
      - clamp
          ( abs(depth) / _Thickness
          , 0
          , 1
          )
      )
    * ( 1
      - clamp
          (  length(positionTo - positionFrom)
            / _MaxDistance
          , 0
          , 1
          )
      )
    * (uv.x < 0 || uv.x > 1 ? 0 : 1)
    * (uv.y < 0 || uv.y > 1 ? 0 : 1);

  uv.z = visibility ;
  outColor = float4(clamp(uv,float3(0.0,0.0,0.0),float3(1.0,1.0,1.0)), 1.0) ;

 // outColor.z = outColor.z * (TEXTURE_GBUFFER_DEPTH.Sample(TEXTURE_GBUFFER_DEPTH_SAMPLER, outColor.xy).r > 0.9999 ? 0.0 : 1.0);
  
}

ENDCG
#END

