

#DEFPARAMS
#END

#DEFTAG
ShaderName = "depthblit"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_NONE
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata   
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float2 uv : TEXCOORD0;
};

Texture2D TEXTURE_SCENE_DEPTH;
SamplerState TEXTURE_SCENE_DEPTH_SAMPLER;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv;
	return o;
}

void frag(in v2f i, out float depth : SV_Depth)
{
    depth = TEXTURE_SCENE_DEPTH.Sample(TEXTURE_SCENE_DEPTH_SAMPLER, i.uv).r;
}
ENDCG
#END


