

#DEFPARAMS
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "CartoonCorrect"
RenderQueue = "Transparent"
#END

#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS } 
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata   
{
	float4 vertex : POSITION;
	float2 uv1 : TEXCOORD0;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float2 uv : TEXCOORD0;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
float4x4 rotMat;
float2   frameSize;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = mul(v.vertex, rotMat);
	o.vertex.xy = (o.vertex.xy / frameSize) * 2.0 - 1.0;
  o.vertex = UniformNDC(o.vertex);
	o.uv = v.uv1.xy;
	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	mainColor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv);
}
ENDCG
#END
