#SHADER_DEFINE SobelVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			MEDIUM,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCoordinate"},
    { PIXEL_OFFSETS,            MEDIUM, VEC2,   "in_Offsets"},
   
	}
	FUNCTION_OUTPUT =
	{
		{ SQUARE_COORDINATE,		  MEDIUM,		VEC2_ARRAY,		"out_SquareCoord", "9" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    
    vec2 out_SquareCoord[9];
    
    // first row
    out_SquareCoord[0] = in_TexCoordinate.xy - in_Offsets.xy;     // upper left corner
    out_SquareCoord[1] = vec2(in_TexCoordinate.x , in_TexCoordinate.y - in_Offsets.y);
    out_SquareCoord[2] = vec2(in_TexCoordinate.x + in_Offsets.x , in_TexCoordinate.y - in_Offsets.y);     // upper right corner
    
    // second row
    out_SquareCoord[3] = vec2(in_TexCoordinate.x - in_Offsets.x , in_TexCoordinate.y);
    out_SquareCoord[4] = in_TexCoordinate.xy;
    out_SquareCoord[5] = vec2(in_TexCoordinate.x + in_Offsets.x , in_TexCoordinate.y);
    
    // thrid row
    out_SquareCoord[6] = vec2(in_TexCoordinate.x - in_Offsets.x , in_TexCoordinate.y + in_Offsets.y);     // lower left corner
    out_SquareCoord[7] = vec2(in_TexCoordinate.x , in_TexCoordinate.y + in_Offsets.y); 
    out_SquareCoord[8] = in_TexCoordinate.xy + in_Offsets.xy;     // lower right corner
    
#END_CODE
#END_DEFINE




#SHADER_DEFINE SobelFragment

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"uniCurrentTexture" },
    { SQUARE_COORDINATE,		  MEDIUM,		VEC2_ARRAY,		"out_SquareCoord", "9" },
    { EDGE_STRENGTH,		  HIGH,		FLOAT,		"edge_strength"},
	}

#SHADER_CODE
      float bottomColor = texture2D(uniCurrentTexture, out_SquareCoord[7]).r;
      float bottomLeftColor = texture2D(uniCurrentTexture, out_SquareCoord[6]).r;
      float bottomRightColor = texture2D(uniCurrentTexture, out_SquareCoord[8]).r;
      float centerColor = texture2D(uniCurrentTexture, out_SquareCoord[4]).r;
      float leftColor = texture2D(uniCurrentTexture, out_SquareCoord[3]).r;
      float rightColor = texture2D(uniCurrentTexture, out_SquareCoord[5]).r;
      float topColor = texture2D(uniCurrentTexture, out_SquareCoord[1]).r;
      float topRightColor = texture2D(uniCurrentTexture, out_SquareCoord[2]).r;
      float topLeftColor = texture2D(uniCurrentTexture, out_SquareCoord[0]).r;
      float horizontaldirection = -topLeftColor +topRightColor-2.0*leftColor+2.0*rightColor-bottomLeftColor+bottomRightColor ;
      float verticaldirection = -topLeftColor -2.0*topColor-topRightColor+bottomLeftColor+2.0*bottomColor+bottomRightColor ;
      float magnitude =length(vec2(horizontaldirection,verticaldirection))*edge_strength;
      gl_FragColor = vec4(vec3(magnitude), 1.0);
#END_CODE
#END_DEFINE