
#DEFPARAMS
_InputTex1 = { "Texture One", TEXTURE2D, "tex1" },
_InputTex2 = { "Texture Two", TEXTURE2D, "tex2" },
_InputTex3 = { "Texture Three", TEXTURE2D, "tex3" },
#END

#DEFTAG
ShaderName = "OneRowThreeTexQuad"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "commonvar.inc"
#include "common.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};

Texture2D _InputTex1;
Texture2D _InputTex2;
Texture2D _InputTex3;
SamplerState _InputTex1_Sampler;
SamplerState _InputTex2_Sampler;
SamplerState _InputTex3_Sampler;


v2f vert(appdata v)
{
    v2f o;
    float4 pos = v.vertex * (1.0 / v.vertex.w);
    pos = ObjectToWorldPos(pos);
    pos.w = 1.0;
    //pos.x = pos.x + WORLD_POSITION.x;
    //pos.y = pos.y + WORLD_POSITION.y;  
    o.vertex = pos;
    o.vertex = UniformNDC(o.vertex);
    o.uv = v.uv.xy;
    return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{

  int row = int(i.uv.x * 3.0);
  float2 textureCoord = i.uv;
  textureCoord.x = (i.uv.x - float(row) / 3.0) * 3.0;
  mainColor = step(row, 0.5)*_InputTex1.Sample(_InputTex1_Sampler, textureCoord) 
    + step(0.5, row)*step(row, 1.5)*_InputTex2.Sample(_InputTex2_Sampler, textureCoord) 
    + step(1.5, row)*_InputTex3.Sample(_InputTex3_Sampler, textureCoord);
}
ENDCG
#END
