#DEFPARAMS
diffuseTex = { "diffuseTex", TEXTURE2D, "white" },
specularTex = {"specularTex", TEXTURE2D, "white"},

baseColor = {"baseColor", COLOR, "0.0,0.0,0.0,1.0"},
DistrubIntensity = { "DistrubIntensity", FLOAT, "0.5" },
Fresnel = { "Fresnel", FLOAT, "0.5" },

shadeColor = {"shadeColor", COLOR, "0.0,0.0,0.0,1.0"},
shift1 = { "shift1", FLOAT, "0.5" },
shift2 = { "shift2", FLOAT, "0.5" },
smoothness1 = { "smoothness1", FLOAT, "0.5" },
smoothness2 = { "smoothness2", FLOAT, "0.5" },
DefSpecular1 = { "DefSpecular1", COLOR, "1.0,1.0,1.0, 1.0" },
DefSpecular2 = { "DefSpecular2", COLOR, "1.0,1.0,1.0, 1.0" },

#END

#DEFTAG
ShaderName = "DollHair"
RenderQueue = "Transparent"
#END

#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdbase
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float3 binoraml : BINORMAL;
	float3 tangent : TANGENT;
	float2 uv : TEXCOORD0;
    ANI_ATTRIBUTE
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 worldnormal : TEXCOORD1;
	float4 worldtangent : TEXCOORD2;
	float4 worldbinormal : TEXCOORD3;
	float4 vertex : SV_POSITION;
	SHADOW_COORDS(4)
};

Texture2D diffuseTex;
Texture2D specularTex;
SamplerState diffuseTex_Sampler;
SamplerState specularTex_Sampler;

float4 baseColor;
float4 shadeColor;
float DistrubIntensity;
float Fresnel;
float shift1;
float shift2;
float smoothness1;
float smoothness2;
float4 DefSpecular1;
float4 DefSpecular2;

v2f vert(appdata v)
{
    COMPUTE_BONE_MATERIX(v);
	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;
	float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
	o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;
	o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;

	o.worldnormal.w = worldpos.x;
	o.worldtangent.w = worldpos.y;
	o.worldbinormal.w = worldpos.z;

	TRANSFER_SHADOW(o, v.vertex);
	return o;
}

void frag(in v2f i, in bool FacingSign : SV_IsFrontFace, out float4 outColor : SV_Target0)
{
    float shadowed = SHADOW_ATTEN(i);
    float3 in_Normal = i.worldnormal.xyz;
    float3 vNormal = normalize(in_Normal);
    float2 texcoord0 = i.uv;

    float3 worldPos = float3(i.worldnormal.w, i.worldtangent.w, i.worldtangent.w);
    float3 viewDir_S = CAMERA_WORLDPOSITION - worldPos.xyz;
    float3 vView = normalize(viewDir_S);

    if(!FacingSign)
    {
        in_Normal = -in_Normal;
    }

    float4 albedo = diffuseTex.Sample(diffuseTex_Sampler, texcoord0);

    float smoothness;
    {
        smoothness = 1.0 - smoothness2;
        float smt_2 = smoothness*smoothness;
        float smt_4 = smt_2*smt_2;
        smt_4 = max(smt_4, 9.9999997e-05);
        smoothness = 2.0 / smt_4 - 2.0;
        smoothness = max(smoothness, 9.9999997e-05);
    }

    float3 shiftNormal1 = (i.worldtangent.xyz - vNormal*float3(shift2, shift2, shift2));
    shiftNormal1 = normalize(shiftNormal1);

    float3 vLight = -(LIGHT_GIVEN_DIRECTION);
    float3 vLight2 = -(LIGHT_GIVEN_DIRECTION);
    float3 vHalf = normalize(vView + vLight);
    float HdotS1 = dot(vHalf, shiftNormal1);
    float mhds = (1.0 - HdotS1*HdotS1);
    mhds = max(mhds, 0.0);
    float tmp = pow(sqrt(mhds), smoothness);

    float4 specColor = specularTex.Sample(specularTex_Sampler, texcoord0);
    float sy = specColor.y*tmp;
    float3 specular1 = DefSpecular2.xyz * float3(sy, sy, sy); 

    float sw = specColor.w*2.0 - 1.0;
    sw = sw*DistrubIntensity + shift1;
    float3 shiftNormal2 = (i.worldtangent.xyz + sw*vNormal);
    shiftNormal2 = normalize(shiftNormal2);
    float HdotS2 = dot(vHalf, shiftNormal2);

    float4 smoothShading = float4(1.0,1.0, 1.0, 1.0) - float4(shadeColor.xyz, smoothness1);
    sw = smoothShading.w*smoothShading.w;
    float sw_2 = sw*sw;
    sw_2 = max(sw_2, 9.9999997e-05);
    sw_2 = 2.0 / sw_2 - 2.0;
    float sw_4 = max(sw_2, 9.9999997e-05);
    mhds = max(1.0 - HdotS2*HdotS2, 0.0);
    float3 specular2 = DefSpecular1.xyz*pow(sqrt(mhds), sw_4); 

    float3 compositeColor = specular1+ specular2;
    compositeColor = compositeColor * specColor.xyz;
    compositeColor = compositeColor * LIGHT_COLOR;

    float VDotN = dot(vView, vNormal);
    VDotN = clamp(VDotN, 0.0, 1.0);
    VDotN = 1.0 - VDotN;
    float v_2 = VDotN*VDotN;
    float v_5 = v_2*v_2*VDotN;
    float mfresnel = smoothness1 * 0.6 + Fresnel;
    mfresnel = min(mfresnel, 1.0);
    float minusFrn = 1.0- mfresnel;
    mfresnel = v_5*minusFrn + mfresnel;

    compositeColor = compositeColor * float3(mfresnel,mfresnel,mfresnel);
    compositeColor = compositeColor * specColor.xyz;

    // front diffuse
    float LdotN = dot(vLight, vNormal);
    float maxldotn = max(0.0, abs(LdotN));
    maxldotn = maxldotn * shadowed;
    maxldotn = min(maxldotn, 1.0);
    float3 frontDiffuse = smoothShading.xyz * float3(maxldotn,maxldotn,maxldotn) + shadeColor.xyz;
    float3 baseTone = baseColor.xyz * albedo.xyz;
    float3 baseTone2 = baseTone*baseTone;
    frontDiffuse = frontDiffuse*LIGHT_COLOR + AMBIENT_COLOR;
    frontDiffuse = frontDiffuse*baseTone2;
 
    float3 finalDiffuse = frontDiffuse;

    float transparency = albedo.w*baseColor.w;
    outColor = float4((compositeColor + finalDiffuse), transparency);
}
ENDCG

#END

#DEFPASS ForwardAdd
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, ONE, ONE, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDADD }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdadd
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float3 binoraml : BINORMAL;
	float3 tangent : TANGENT;
	float2 uv : TEXCOORD0;
    ANI_ATTRIBUTE
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 worldnormal : TEXCOORD1;
	float4 worldtangent : TEXCOORD2;
	float4 worldbinormal : TEXCOORD3;
	float4 vertex : SV_POSITION;
	SHADOW_COORDS(4)
};

Texture2D diffuseTex;
Texture2D specularTex;
SamplerState diffuseTex_Sampler;
SamplerState specularTex_Sampler;

float4 baseColor;
float4 shadeColor;
float DistrubIntensity;
float Fresnel;
float shift1;
float shift2;
float smoothness1;
float smoothness2;
float4 DefSpecular1;
float4 DefSpecular2;

v2f vert(appdata v)
{
    COMPUTE_BONE_MATERIX(v);
	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;
	float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
	o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;
	o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;

	o.worldnormal.w = worldpos.x;
	o.worldtangent.w = worldpos.y;
	o.worldbinormal.w = worldpos.z;

	TRANSFER_SHADOW(o, v.vertex);
	return o;
}

void frag(in v2f i, in bool FacingSign : SV_IsFrontFace, out float4 mainColor : SV_Target0)
{
    float shadowed = SHADOW_ATTEN(i);
    float3 in_Normal = i.worldnormal.xyz;
    float3 vNormal = normalize(in_Normal);
    float2 texcoord0 = i.uv;

    float3 worldPos = float3(i.worldnormal.w, i.worldtangent.w, i.worldtangent.w);
    float3 viewDir_S = CAMERA_WORLDPOSITION - worldPos.xyz;
    float3 vView = normalize(viewDir_S);

    if(!FacingSign)
    {
        in_Normal = -in_Normal;
    }

    float4 albedo = diffuseTex.Sample(diffuseTex_Sampler, texcoord0);

    float smoothness;
    {
        smoothness = 1.0 - smoothness2;
        float smt_2 = smoothness*smoothness;
        float smt_4 = smt_2*smt_2;
        smt_4 = max(smt_4, 9.9999997e-05);
        smoothness = 2.0 / smt_4 - 2.0;
        smoothness = max(smoothness, 9.9999997e-05);
    }

    float3 shiftNormal1 = (i.worldtangent.xyz - vNormal*float3(shift2, shift2, shift2));
    shiftNormal1 = normalize(shiftNormal1);

    float3 vLight = -(LIGHT_GIVEN_DIRECTION);
    float3 vLight2 = -(LIGHT_GIVEN_DIRECTION);

    float3 vHalf = normalize(vView + vLight);
    float HdotS1 = dot(vHalf, shiftNormal1);
    float mhds = (1.0 - HdotS1*HdotS1);
    mhds = max(mhds, 0.0);
    float tmp = pow(sqrt(mhds), smoothness);

    float4 specColor = specularTex.Sample(specularTex_Sampler, texcoord0);
    float sy = specColor.y*tmp;
    float3 specular1 = DefSpecular2.xyz * float3(sy, sy, sy);

    float sw = specColor.w*2.0 - 1.0;
    sw = sw*DistrubIntensity + shift1;
    float3 shiftNormal2 = (i.worldtangent.xyz + sw*vNormal);
    shiftNormal2 = normalize(shiftNormal2);
    float HdotS2 = dot(vHalf, shiftNormal2);

    float4 smoothShading = float4(1.0,1.0, 1.0, 1.0) - float4(shadeColor.xyz, smoothness1);
    sw = smoothShading.w*smoothShading.w;
    float sw_2 = sw*sw;
    sw_2 = max(sw_2, 9.9999997e-05);
    sw_2 = 2.0 / sw_2 - 2.0;
    float sw_4 = max(sw_2, 9.9999997e-05);
    mhds = max(1.0 - HdotS2*HdotS2, 0.0);
    float3 specular2 = DefSpecular1.xyz*pow(sqrt(mhds), sw_4);

    float3 compositeColor = specular1+ specular2;
    compositeColor = compositeColor * specColor.xyz;
    compositeColor = compositeColor * LIGHT_COLOR;

    float VDotN = dot(vView, vNormal);
    VDotN = clamp(VDotN, 0.0, 1.0);
    VDotN = 1.0 - VDotN;
    float v_2 = VDotN*VDotN;
    float v_5 = v_2*v_2*VDotN;
    float mfresnel = smoothness1 * 0.6 + Fresnel;
    mfresnel = min(mfresnel, 1.0);
    float minusFrn = 1.0- mfresnel;
    mfresnel = v_5*minusFrn + mfresnel;

    compositeColor = compositeColor * float3(mfresnel,mfresnel,mfresnel);
    compositeColor = compositeColor * specColor.xyz;

     // back diffuse
    float minusL2dotN = dot(-vLight2, vNormal);
    minusL2dotN = clamp(minusL2dotN, 0.0, 1.0);

    float LdotN = dot(vLight, vNormal);
    float L2dotN = dot(vLight2, vNormal);
    L2dotN = clamp(L2dotN, 0.0, 1.0);

    float3 lightSpec = float3(specColor.y, specColor.y, specColor.y) * LIGHT_COLOR;
    lightSpec = float3(shadowed, shadowed, shadowed) * lightSpec;
    float3 halfLightSpec = lightSpec*float3(0.5,0.5,0.5);
    halfLightSpec = halfLightSpec*float3(L2dotN, L2dotN, L2dotN);
    float3 baseTone = baseColor.xyz * albedo.xyz;
    float3 baseTone2 = baseTone*baseTone;
    float3 backDiffuse = halfLightSpec*baseTone2;
    float3 toneNormalizer = backDiffuse + float3(1.0,1.0,1.0);
    backDiffuse = backDiffuse/toneNormalizer;
    backDiffuse *= float3(L2dotN, L2dotN, L2dotN);

    float3 finalDiffuse = backDiffuse;

    float transparency = albedo.w*baseColor.w;
    mainColor = float4((finalDiffuse * transparency), 1.0);
}
ENDCG

#END

#DEFPASS Depth
	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	CGPROGRAM
	#pragma vertex vert
	#pragma fragment frag
	#include "lightpbr.inc"

	struct appdata
	{
		float4 vertex : POSITION;
		float3 normal : NORMAL;
        ANI_ATTRIBUTE
	};
  
	struct v2f
	{
		float4 vertex : SV_POSITION;
	};

	v2f vert(appdata v)
	{
        COMPUTE_BONE_MATERIX(v);
		float4 clipPos = ObjectToClipPos(v.vertex);
		clipPos = ApplyShadowBias(clipPos);

		v2f o;
		o.vertex = UniformNDC(clipPos);
		return o;
	}

	void frag(in v2f i, out float4 mainColor : SV_Target0)
	{
		mainColor = float4(0.0, 0.0, 0.0, 1.0);
	}
	ENDCG
#END