local apolloengine = require "apolloengine"
local apollonode = require "apolloutility.apollonode"
local mathfunction = require "mathfunction"
local math = require "math"
local venuscore = require "venuscore"

local mlaamain={};

function mlaamain:Initialize(camera,config)
  
  self.maincamera = camera;
  self.post = apollonode.PostEffect();
  --self.lpath = venuscore.IFileSystem:PathAssembly("ress:filter/resource");
  local mlaapath = "comm:script/apolloutility/posteffect";
  self.post:CreateResource(mlaapath.."/mlaa.lua"); 
  self.maincamera:AttachPostEffect(self.post);
  
  local tex = apolloengine.TextureEntity();
  local path ="comm:/documents";
  local imagePath = path.."/material/tex/mlaa/AreaMap32.png";
  tex:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_NEAREST,
      apolloengine.TextureEntity.TF_NEAREST,
      imagePath));
  local res = tex:CreateResource();
  self.tex = tex;
  self.blwmaterialpath = path.."/material/blendweight.material";
  self.post:RegisterParameter("TEXTURE_AREAMAP", self.blwmaterialpath);
  self.post:TEXTURE_AREAMAP(self.tex);
  
  
end


function mlaamain:SetParameterValue(slotname, material,value)
  local ps = apolloengine.IMaterialSystem:GetParameterSlot(slotname);
  local mat = self.post.post:GetMaterial(material);
  mat:SetParameter(ps, value);
 
end

function mlaamain:Update(def)
end

function mlaamain:OnRecordStart()
end

function mlaamain:Exit()
  self.post:Disable();

end

return mlaamain;