

local apollonode = require "apolloutility.apollonode"
local defined = require "apolloutility.defiend"
local mathfunction = require "mathfunction"
local apolloengine = require "apollocore"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local apollocore = require "apollocore"
local apolloDefine = require "apolloutility.defiend"
local ContentManager = require "apolloengine.content.contentmanager"
local GiftScene = require "gifteffect.giftscene"

--礼物Scene的BaseSequence
--local BASE_SCENE_SEQUENCE = 1000


--直播礼物Manager
local GiftManager = {}

function GiftManager:Initialize()
  self.baseSequence = 1000;
  self.giftSceneList = {};
  self.giftSequenceList = {};
end

function GiftManager:Update(spantime)
  for key, value in pairs(self.giftSceneList) do
    if value then
      value:Update(spantime);
    end
  end
end

--设置礼物的渲染目标
function GiftManager:SetOutputTarget(rt)
  for sequence,gift in pairs(self.giftSceneList) do
    if gift then
      gift:SetOutputTarget(rt);
    end
  end
end


function GiftManager:OnRecordStart()
end

function GiftManager:AddGift(path)
  local handle = -1;
  local isExist = venuscore.IFileSystem:isFileExist(path);
  if isExist == false then
    ERROR("scene file do not exist!!!");
    return handle;
  end
  
  local rootConfig = venusjson.LaodJsonFile(path);
  if rootConfig.scene then
    --设置ress路径
    local pathDir= string.match(path, "(.+)/[^/]*%.%w+$");
    local rootdir = pathDir.."/";
    
    venuscore.IFileSystem:SetGiftResourcePath(rootdir);

    local GiftSequence = self:_GetMaxSceneSequence();
    
    local Gift = GiftScene(GiftSequence);
    local res = Gift:LoadConfig(rootConfig.scene);
    res = res and Gift:LoadAttributeConfig(rootdir .. "custom_gift_config.json");  --可更改属性配置(由编辑器生成，供引擎和客户端使用)
    Gift:HideAvatar();
    if Gift and res == true then  --场景和配置都加载成功才返回handle
      handle = GiftSequence;
      self.giftSceneList[GiftSequence] = Gift; 
    end
  end
  WARNING("GiftManager:AddGift handle is: " .. tostring(handle))
  return handle;
end

function GiftManager:SetAttribute(attributeName,attributeValue)
  local res = true;
  for sequence,gift in pairs(self.giftSceneList) do
    if gift then
      res = res and gift:SetAttribute(attributeName,attributeValue);
    end
  end
  return res;
end

--播放场景
function GiftManager:PlayGift()
  local res = true;
  for sequence,gift in pairs(self.giftSceneList) do
    if gift then
      res = res and gift:PlayGift();
    end
  end
  return res;
end

function GiftManager:PlayGiftWithHandle(handle)
  local res = true;
  local gift = self.giftSceneList(handle);
  if gift then
    res = res and gift:PlayGift();
  end
  return res;
end


--预览场景
function GiftManager:PreviewGift()
  local res = true;
  for sequence,gift in pairs(self.giftSceneList) do
    if gift then
      res = res and gift:PreviewGift();
    end
  end
  return res;
end

function GiftManager:ZoomGift(zoom)
  for sequence,gift in pairs(self.giftSceneList) do
    if gift then
      gift:ZoomGift(zoom);
    end
  end
end

function GiftManager:RotateGift(xAngle,yAngle)
  for sequence,gift in pairs(self.giftSceneList) do
    if gift then
      gift:RotateGift(xAngle,yAngle);
    end
  end
end

function GiftManager:ResetGift()
  for sequence,gift in pairs(self.giftSceneList) do
    if gift then
      gift:ResetGift();
    end
  end
end

function GiftManager:StartCapture()
  for sequence,gift in pairs(self.giftSceneList) do
    if gift then
      gift:StartCapture();
    end
  end
end


--卸载所有礼物
function GiftManager:ReleaseAllGift()
  for key, value in pairs(self.giftSceneList) do
    self:ReleaseGift(key);
  end
  self.giftSceneList = {};
end

--卸载单个礼物
function GiftManager:ReleaseGift(handle)
  local giftScene = self.giftSceneList[handle];
  if giftScene then
    giftScene:Release();
    self.giftSceneList[handle] = nil;
    WARNING("GiftManager:ReleaseGift handle is: " .. tostring(handle))
  end
  return true;
end

--取得场景
function GiftManager:GetGift(handle)
  local giftScene = self.giftSceneList[handle];
end

function GiftManager:_GetMaxSceneSequence()
  self.baseSequence = self.baseSequence + 1;
  return self.baseSequence;
end


return GiftManager;
