--local renderqueue     = require "apolloutility.renderqueue"
local apolloengine    = require "apolloengine"
local apollonode = require "apolloutility.apollonode"
local mathfunction    = require "mathfunction"
local venuscore       = require "venuscore"
local facetrans       = require "facemorph.facemorph"

require "venusdebug"
require "utility"

local main = {}

function main:Timespan()
  local now = venuscore.ITimerSystem:GetTimevalue();
  local def = now - self.begintime;
  self.begintime = now;

  self.cumtime = self.cumtime + def;
  self.fps = self.fps + 1;

  if self.cumtime > 50 then
    local fps = self.fps / self.cumtime;
    self.fps = 0;
    self.cumtime = 0;
    --LOG("FPS "..fps);
  end
  return self.cumtime;
end


function main:CreateCamera()
  self.maincamera = apollonode.CameraNode();
  self.maincamera:CreatePerspectiveProjection(1, 10);--使用透视摄像机以及远近裁剪
	self.maincamera:LookAt(
    mathfunction.vector3(0,0,5),
		mathfunction.vector3(0,0,0),
		mathfunction.vector3(0,1,0));--设置摄像机view矩阵
  self.maincamera:Activate();
end

--size,video表示视屏纹理尺寸和id,size为table
function main:Initialize()
  _COROUTINES_ON();
  local res = apolloengine.Framework:GetResolution();
  self:CreateCamera();

  facetrans:Initialize(res:x(), res:y());

  self.isLoaded = facetrans:LoadConfig("docs:facemorph/facemorph.json");
  
  --设置同步更新事件，这个事件会阻塞渲染线程，可以在这个线程中做资源读取等操作
  --但是这个事件也会大大降低帧率
  apolloengine.Framework:AddSynchronizeUpdateCallback(self._Agent, "Update");

  self.begintime = venuscore.ITimerSystem:GetTimevalue();
  self.cumtime = 0;
  self.fps = 0; 
  
  LOG("initialize done");
  _COROUTINES_OFF();
  return true;
end

local isload = false;

function main:Update()
  _COROUTINES_ON();
  if self.isLoaded then
    local def = self:Timespan();
    facetrans:Update(def);
  end
  _COROUTINES_OFF();
end

function main:Abort()
  apolloengine.Framework:RemoveSynchronizeUpdateCallback(self._Agent, "Update");
  venuscore.IApplication:Abort();
end


return main;
