require "venusdebug"
local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode.quadnode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"
local facecute = require "facecute"
local faceinfo = require "videodecet.faceinfo";
require "utility"


local facelifting = apollonode:extend();

--size,video表示视屏纹理尺寸和id,size为table
function facelifting:Initialize()
  
  facelifting.super.new(self);  
  
  apolloengine.ShaderEntity.UNIFORM_LEFT_EYE =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"UNIFORM_LEFT_EYE");
  apolloengine.ShaderEntity.UNIFORM_RIGHT_EYE =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"UNIFORM_RIGHT_EYE");
  apolloengine.ShaderEntity.UNIFORM_RADIUS =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"UNIFORM_RADIUS");
    
  apolloengine.ShaderEntity.UNIFORM_RATIOASPECT =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"UNIFORM_RATIOASPECT");
    
  apolloengine.ShaderEntity.UNIFORM_LEFT_PTS =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"UNIFORM_LEFT_PTS");
  apolloengine.ShaderEntity.UNIFORM_RIGHT_PTS =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"UNIFORM_RIGHT_PTS");

  apolloengine.ShaderEntity.UNIFORM_COEF =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"UNIFORM_COEF");
  apolloengine.ShaderEntity.UNIFORM_NOSE =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"UNIFORM_NOSE");
    
  apolloengine.ShaderEntity.UNIFORM_FACESNUM =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"UNIFORM_FACESNUM");
    
  self:CreateResource("comm:documents/material/biggereyes.material",false);
  --self.render:CreateResource("docs:facecute/material/Thinnerfaces.material",true);
  
  self:SetShow(true);
  self:SetCull(false);
  
  renderqueue:Before(self);
  

  
  self.resolution = apolloengine.Framework:GetResolution();
  self.aspect_ratio = self.resolution:y()/self.resolution:x();
  self:SetParameter(apolloengine.ShaderEntity.UNIFORM_RATIOASPECT, mathfunction.vector1(self.aspect_ratio));  
--  self.render:SetParameter(apolloengine.ShaderEntity.UNIFORM_RADIUS, mathfunction.vector1(0.08));  
--	float aspectRatio = 1.0 / 0.5625;

  self.contourIdx = {};
  for i = 1, 11, 1 do
    self.contourIdx[i] = 5 + i;
  end
  for i = 12, 22, 1 do
    self.contourIdx[i] = 28 - (i - 12);
  end
  
  self.level = 0;
  
end

function facelifting:GetVector2dLength(vec)
  return math.sqrt(vec:x()*vec:x()+vec:y()*vec:y());
end

function facelifting:GetDistance(src,dst)
  local dx = src[1] - dst[1];
  local dy = src[2] - dst[2];
  return math.sqrt(dx*dx+dy*dy);
end


function facelifting:arrayToVec2(pt)
  return mathfunction.vector2(pt[1], pt[2]);
end

--[[
function facelifting:screenToTexture(pt)
  return {pt[1] * 0.5 + 0.5,pt[2] * 0.5 + 0.5};
end
]]--

--脸周
function facelifting:UpdateFaceKeypoints(currentPoint, src,  dst, radius, delta)

--     local currentPointToUse = {currentPoint[1],currentPoint[2] * self.aspect_ratio + 0.5 - 0.5 * self.aspect_ratio};
--     local srcToUse = {src[1],src[2] * self.aspect_ratio + 0.5 - 0.5 * self.aspect_ratio};
    local currentPointToUse = {currentPoint[1],currentPoint[2] * self.aspect_ratio};
     local srcToUse = {src[1],src[2] * self.aspect_ratio};  
     local r = self:GetDistance(currentPointToUse , srcToUse);
     
     local positionToUse = currentPoint;

     if r < radius then
         local dir = mathfunction.vector2(src[1] - dst[1],src[2] - dst[2]);
         dir:NormalizeSelf();         
         local dist = radius * radius - r * r;
         local alpha = dist / (dist + (r-delta) * (r-delta));
         alpha = alpha * alpha;
         positionToUse[1] = positionToUse[1] - alpha * delta * dir:x();
         positionToUse[2] = positionToUse[2] - alpha * delta * dir:y();
         return positionToUse, 1;
  --       positionToUse = positionToUse - alpha * delta * dir;
    end
    
    return positionToUse, 0;
  
end

--眼睛
function facelifting:UpdateEyesKeypoints(pt,center,radius)
  	local scaleRatio = 0.5;     
    local positionToUse = pt;

 --   local currentPositionToUse = {pt[1],pt[2] * self.aspect_ratio + 0.5 - 0.5 * self.aspect_ratio};
 --   local centerPostionToUse = {center[1],center[2] * self.aspect_ratio + 0.5 - 0.5 * self.aspect_ratio};
    local currentPositionToUse = {pt[1],pt[2] * self.aspect_ratio};
    local centerPostionToUse = {center[1],center[2] * self.aspect_ratio};
    local r = self:GetDistance(currentPositionToUse , centerPostionToUse);
    
    local R = radius;
    if r < R then
         local alpha = 1.0 + scaleRatio * math.pow(r / R - 1.0, 2.0);
         positionToUse[1] = center[1] + alpha * (pt[1] - center[1]);
         positionToUse[2] = center[2] + alpha * (pt[2] - center[2]);
         return positionToUse, 1;
    --     positionToUse = center + (2.0 - alpha) * (pt - center);
    end
        
    return positionToUse,0;
end

function facelifting:NewframeCallback()
  self.newframecallback = function()    
      local tex = videodecet:GetVideoTexture();
   -- renderqueue:FaceLifting(self);
    --local tex = renderqueue:Queue(1,self);
    self:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, tex);
   -- level = level * 2;
    
    --大眼参数
    local cof = 1.0 + self.level * 0.22;
    
     --瘦脸系数
    local coef = math.sqrt(self.level * 0.2);
    
    local lefteyes = mathfunction.vector2array();
    local righteyes = mathfunction.vector2array();
    local leftPointArray = mathfunction.vector2array();
    local rightPointArray = mathfunction.vector2array();
    local nose = mathfunction.vector2array();
    --左、右眼
    local radiuses = mathfunction.vector2array();
    
    local faces = videodecet:GetFaces();
    
    local maxFaceNum = 3;
    local faceNum = math.min(maxFaceNum,#faces);
    
    if self.level == 0 then
      faceNum = 0;
    end
    
    self:SetParameter(apolloengine.ShaderEntity.UNIFORM_FACESNUM,mathfunction.vector1(faceNum));
      
    --todo several faces
    if faces then
            
      for k=1, faceNum,1 do--提取关键点
        local faceinfo = faces[k];
        local keypoints = faceinfo:GetKeypointArray();
    --商汤从0开始，Lua从1开始，index需+1
    --    keypointNum = #keypoints;
        local c1 = self:arrayToVec2(keypoints[75]);
        local pt2 = self:arrayToVec2(keypoints[74]);
        local r1 = self:GetVector2dLength(pt2 - c1) ;
        --lefteye = mathfunction.vector2(c1[1] * 0.5 + 0.5,c1[2] * 0.5 + 0.5);
        --左眼
        lefteyes:PushBack(c1);
        
        
        local c2 = self:arrayToVec2(keypoints[78]);
        pt2 = self:arrayToVec2(keypoints[77]);
        local r2 = self:GetVector2dLength(pt2 - c2);
        --右眼
        righteyes:PushBack(c2);
        
        radiuses:PushBack(mathfunction.vector2(r1*cof * 2.5,r2*cof * 2.5));
        
        
        --瘦脸      
        for i = 6,16,1 do
          leftPointArray:PushBack(self:arrayToVec2(keypoints[i]));
        end
        
        for i = 28,18,-1 do
          rightPointArray:PushBack(self:arrayToVec2(keypoints[i]));
        end
        --鼻子
        nose:PushBack(self:arrayToVec2(keypoints[47]));
        
      
        local ns = keypoints[47];      
        local flag = 0;
      
        --更新眼周关键点位置
        --眼眶中心可不更新
        for i=53,77,1 do
          if i ~= 75 and (i <= 64 or i >= 73) then
            local pt = keypoints[i];
            pt,flag = self:UpdateEyesKeypoints(pt,keypoints[75],r1*cof * 2.5);         
            pt,flag = self:UpdateEyesKeypoints(pt,keypoints[78],r2*cof * 2.5);
          end
        end
        
	        --更新脸周位置  
        for i = 1,22,1 do
          local pt = keypoints[self.contourIdx[i]];        
          local k1 = self:GetDistance(pt,ns) * coef;
          pt,flag = self:UpdateFaceKeypoints(pt, pt, ns, 0.72 * k1, 0.04 * k1);  
        end
               
      end
    end

    self:SetParameter(apolloengine.ShaderEntity.UNIFORM_LEFT_EYE,lefteyes);
    self:SetParameter(apolloengine.ShaderEntity.UNIFORM_RIGHT_EYE,righteyes);
    self:SetParameter(apolloengine.ShaderEntity.UNIFORM_RADIUS,radiuses); 
    
    --瘦脸系数
    self:SetParameter(apolloengine.ShaderEntity.UNIFORM_COEF,mathfunction.vector1(coef));

    self:SetParameter(apolloengine.ShaderEntity.UNIFORM_LEFT_PTS,leftPointArray);
    self:SetParameter(apolloengine.ShaderEntity.UNIFORM_RIGHT_PTS,rightPointArray);         
    self:SetParameter(apolloengine.ShaderEntity.UNIFORM_NOSE, nose);
  end  
  return self.newframecallback;
end

--[[
function facelifting:getWarpedKeyPoints()
  
  return self.Keypoint;
  
end
]]--
function facelifting:setWarpLevel(level)
  
  self.level = level;
  
end

return facelifting;
