--管理多个变形器
local transfer = require "facecute.deformation.transfer3New"
local bezier = require "facecute.deformation.bezier3New"
local deformation = require "facecute.deformation.deformation"
local renderqueue = require "apolloutility.renderqueue"
local EffectAgent = require "facecute.effectagent"

local deformation3 = deformation:extend();
function deformation3:new(maincamera)
    deformation3.super.new(self, maincamera);
    self.deformationnames = {}
    self.deformations = {}
end

function deformation3:getAsset(name)
    local len = table.getn(self.deformationnames);
    for i = 1, len do
        if (name == self.deformationnames[i])
        then
            return self.deformations[i];
        end
    end
    return nil;
end

--传入deformation数据表，解析数据生成变形器组件
function deformation3:ParseConfig(config, para)
    local defpara = {};
    for name, pa in pairs(para) do
        defpara["name"] = pa;
    end

    local version = tonumber(config["version"]);
    defpara["version"] = para[2];
    for i = 1, #config["deformations"] do
        local deformation_tmp = config["deformations"][i]
        --LOG(("name: [%s]"):format(deformation_tmp["name"]))
        --LOG(("centerOffset: [%f %f]"):format(deformation_tmp["centerOffset"][1],deformation_tmp["centerOffset"][2]))
        if (deformation_tmp["transfer"] == true) then
            local t = transfer(self.maincamera);
            --renderqueue:Queue(i,t);
            defpara["layerOrder"] = i;
            t:ParseConfig(deformation_tmp, defpara);
            table.insert(self.deformationnames, deformation_tmp["name"]);
            table.insert(self.deformations, EffectAgent(t, deformation_tmp["name"]));

        end
        if (deformation_tmp["transfer"] == false) then
            local b = bezier(self.maincamera);
            --renderqueue:Queue(i,b);
            defpara["layerOrder"] = i;
            b:ParseConfig(deformation_tmp, defpara);
            table.insert(self.deformationnames, deformation_tmp["name"]);
            table.insert(self.deformations, EffectAgent(b, deformation_tmp["name"]));
        end
    end
    self:AddToRenderQueue();
end

function deformation3:AddToRenderQueue()
    local index =1;
    local len = #self.deformations;
    for i =1, len do
        local b = self.deformations[i]:GetEffectObj();
        b.addIndex = index;
        index = index+1;
        renderqueue:AddObjs(b);
        local z = b.addIndex/10000+renderqueue:GetMaxFaceOrder();
         b:SetRenderOrder(z);
    end
end

function deformation3:SetRootNode(node)
    for _, def in ipairs(self.deformations) do
        def:SetRootNode(node)
    end
end

function deformation3:ReleaseResource()
    deformation3.super.ReleaseResource(self);
end

return deformation3;
