local mathfunction = require "mathfunction"
local utility = require "emoji.emojiUtility"
local bsmodel = require "emoji.bsmodel"

local face = bsmodel:extend();

function face:new()
  face.super.new(self);
  self.weights_correct = {};
  self.adjust_weight = false;
end

function face:CreateModel(face_config, attach_to_node, boundingbox, render_before)
  face.super.CreateModel(self, face_config, attach_to_node, boundingbox, render_before);
  
  if (self.model ~= nil) then
    -- read the blendshape corrects
    local blendshape_config = face_config.blendshape;
    if blendshape_config["correct"] ~= nil then
      for key, value in pairs(blendshape_config.correct) do
        self.weights_correct[key] = value;
      end
    end  
    
    -- pos related parameters
    self.pos_adjust = mathfunction.vector3(unpack(face_config.pos or {0, 0, 0}));
    self.rot_adjust = utility.DegreeToYawPitchRoll(face_config.rot or {0, 0, 0});
    self.scale_adjust =  mathfunction.vector3(unpack(face_config.scale or {1, 1, 1}));

    self.start_close_weight = face_config.start_close_weight or 1.0;
    self.end_close_weight = face_config.end_close_weight or 1.0;
    
    if self.start_close_weight ~= nil and self.end_close_weight ~= nil then
      self.adjust_weight = true;
      self.eye_close_weight = 1.0/(self.end_close_weight * self.end_close_weight);
    end
  end
end

function face:UpdateModel(input_data)
  if self.model ~= nil and input_data ~= nil then
    self.model:SetLocalRotation(self.rot_adjust);
    self.model:SetLocalScale(self.scale_adjust);
    
    --接受weights, 计算blend
    local face_weights = {};
    local weights_dict = input_data.weights_dict;
    local name_index_map = self.model:GetNameIndexMap();
    for name, index in pairs(name_index_map) do
      face_weights[index] =  weights_dict[name] or 0;
    end
  
    self.model:UpdateBlendshape(face_weights);
  end
end

function face:GetLookAtPoints()
  local lookat = nil;
  if (self.bs ~= nil) then
    lookat = self.bs:ReceiveLookAtPoints();
    if lookat == nil or (math.abs(lookat:x())<0.00001 and math.abs(lookat:y())<0.00001 and math.abs(lookat:z())<0.00001) then
      lookat = mathfunction.vector3(0.0,0.0,1.0);
    end
  end 
  return lookat;
end

function face:AdjustWeight(weights_dict)
  if self.adjustWeight then
    weights_dict[eyeBlinkLName] = self:AdjustBlinkWeight(weights_dict[eyeBlinkLName]);
    weights_dict[eyeBlinkRName] = self:AdjustBlinkWeight(weights_dict[eyeBlinkRName]);
  end
  
  ---将各权重赋予对应weights位置
  if self.model ~= nil then
    for key, correct in pairs(self.weights_correct) do
      local weight = weights_dict[key];
      if weight ~= nil then
        weight = weight * correct;
        if weight > 1 then
          weight = 1;
        end
        -- assign back
        weights_dict[key] = weight;
      end
    end
  end
end

function face:AdjustBlinkWeight(weight)
  -- weight: [0,1]
  local result = weight * weight * self.eye_close_weight;
  if result < self.start_close_weight then
    result = 0;
  else
    result = (result - self.start_close_weight) * (1.0 / (1.0 - self.start_close_weight));
    if result > 1 then
      result = 1;
    end
  end
  return result;
end

return face;