local mathfunction = require "mathfunction"
local utility = require "emoji.emojiUtility"
local model = require "emoji.model"

local eye = model:extend();

function eye:new()
  eye.super.new(self);
  self.eye_scale = {1.0, 1.0};
end

function eye:CreateModel(config, attach_to_model, boundingbox, render_before)
  eye.super.CreateModel(self, config, attach_to_model, boundingbox, render_before);
  
  if (self.model ~= nil) then
    self.eye_scale = config.dir_scale or {1.0, 1.0};
  end
end

function eye:UpdateModel(input_data)
  if(input_data == nil) then
    return;
  end
  
  local lookat_v3 = input_data.lookat;
  local look_from = mathfunction.vector3(0.0,0.0,1.0);  
  if lookat_v3 == nil or (math.abs(lookat_v3:x())<0.00001 and math.abs(lookat_v3:y())<0.00001 and math.abs(lookat_v3:z())<0.00001) then
    lookat_v3 = mathfunction.vector3(0.0,0.0,1.0);
  end
  
  local look_at = self:ScaleLookat(lookat_v3,  self.eye_scale[1],  self.eye_scale[2]);

  if self.model ~= nil then
    local quat = mathfunction.Mathutility:AxisToAxis(look_from,look_at);
    self.model:SetLocalRotation(quat);
  end
end

function eye:ScaleLookat(lookat_v3, scaleX, scaleY)
  local x = lookat_v3:x();
  local y = lookat_v3:y();
  if scaleX ~= nil then
    x = x * scaleX;
  end
  if scaleY ~= nil then
    y = y * scaleY;
  end
  local z = math.sqrt(1.0 - x * x - y * y);
  return mathfunction.vector3(x, y, z);
end

return eye;