local defined       = require "cartoon.defined"
local venuscore     = require "venuscore"
local venusjson     = require "venusjson"

local _R = {}

function _R:LoadLabels(labels_file)
  local full_path = venuscore.IFileSystem:PathAssembly(labels_file)
  self.labels_config = venusjson.LaodJsonFile(full_path)
end

function _R:LoadResources(res_config)   
   local full_path = venuscore.IFileSystem:PathAssembly(res_config)
   self.default_config = venusjson.LaodJsonFile(full_path)
end

function _R:GetTemplate(gender)
  if self.default_config.template ~= nil
  then
    return self.default_config.template[gender]
  end
  return nil
end

function _R:GetResource(name, label, gender)
  local model_name, model_label = self:_GetModelLabel(name, label, gender)
  return model_name, self:_GetModelResource(model_name, model_label, gender)
end

function _R:_GetModelLabel(name, label, gender)
  if self.labels_config[name] ~= nil and self.labels_config[name].label ~= nil
  then
    local model_name = self.labels_config[name].model
    if self.labels_config[name].label[gender] ~= nil
    then
      return model_name, self.labels_config[name].label[gender][tostring(label)]
    end
    return model_name, self.labels_config[name].label[tostring(label)]
  end
  return nil, nil
end

function _R:_GetModelResource(name, label, gender)
  if self.default_config.models ~= nil and self.default_config.models[name] ~= nil
  then
    if self.default_config.models[name][gender] ~= nil
    then
      return self.default_config.models[name][gender][label]
    end
    return self.default_config.models[name][label]
  end
  return nil
end

return _R 