local SequenceAnimation = require "apolloutility.sequenceanimation"
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local MaskSequenceBase = require "biugo.mask_sequence_base"
local venuscore = require "venuscore"
local videodecet = require "videodecet"
local biugodefined = require "biugo.defined"
local asynctexture = require "apolloutility.asynctexture.asynctexture"
local Object = require "classic"



local MaskSequence = MaskSequenceBase:extend();

function MaskSequence:new(customID,channel, isText, materialName, alphaMode, splitInfo,renderorder)
  MaskSequence.super.new(self,customID,channel, isText, materialName, alphaMode, splitInfo,renderorder);
  
  --windows mask 测试  
  self.mask_imagereader = asynctexture();
  self.mask_imagereader:SetKeepSource(false);
  self.mask_imagereader:SequentialLoad(30, true, 1, biugodefined.windows_mask_sequence_path .. "/" .. biugodefined.windows_mask_sequence_name, nil);
  self.mask_imagereader:Preloading();
  
  local custom_texture = apolloengine.TextureEntity();
  custom_texture:PushMetadata(
    apolloengine.TextureFileMetadata(biugodefined.windows_custom_texture_path .. biugodefined.windows_custom_texture_name));
  custom_texture:CreateResource();
  self.custom_texture = custom_texture;
  self.custom_texture_size = custom_texture:GetSize();  --对于文字需要简单的缩放排版
end

function MaskSequence:Update(timespan)
  
  local custom_texture = apolloengine.TextureEntity();
  local custom_texture_name = biugodefined.windows_custom_texture_name;
  if self.maskID == 1 then
    custom_texture_name = "output1.jpg";
  end
  if self.maskID == 2 then
    custom_texture_name = "output3.png";
  end
  
  custom_texture:PushMetadata(
    apolloengine.TextureFileMetadata(biugodefined.windows_custom_texture_path .. custom_texture_name));
  custom_texture:CreateResource();
  self.custom_texture = custom_texture;
  
  local rgb, alpha, frame, isplaying = 0;
  rgb, frame, alpha, isplaying = self.mask_imagereader:Update(timespan);
  --LOG("FrameIndex is: " .. tostring(frame));
  if rgb and isplaying then
    self.mask_texture = rgb;
  else
    self.mask_textrue = self.empty_mask_texture;
  end
  MaskSequence.super.Update(self,frame);
end

function MaskSequence:SetMaskTexture(id,texid,size)
end


return MaskSequence;


