

local apolloengine  = require "apolloengine"
local rendernode    = require "apolloutility.apollonode.rendernode"
local mathfunction  = require "mathfunction"
local cv            = require "computervisionfunction"
local venuscore     = require "venuscore"
local defined       = require "apolloutility.defiend"
local apollonode   = require "apolloutility.apollonode"
local DeviceResource = require "apolloengine.deviceresource"
local quad_render   = require "haircolor.haircolor_bbox"
local haircolor_render    = require "haircolor.haircolor_render"
--[[
    Render Blings as billboards on background frame.
    Usage:
    1. Create a BlingEffect object, make sure patch_creator_render_sequence is less than that of the main camera.
    2. call Update() in rendering Update()
]]

local HairColorBehavior = venuscore.VenusBehavior:extend("HairColorBehavior");


function HairColorBehavior:new()
    self.Texture_path = "comm:documents/texture/material/blank.jpg";
    self.lut_map = "comm:documents/make_up/lut/darken.png";
    self.initialized = false;
    self.Strength = 0.24;
    self.Bright = 2 - 0.69;
    self.Default_mode = true;
    self.U = 0;
    self.V = 0;
    self.Scale = 1;
    
    self.Overlay_mode = 1.0;
    self.Blend_opacity = 1.0;
    self.Mask_ratio = 1.0;
    self.sequence = -500;
    self.Color_mode = 1;
    self.offset = 0;
    self.ClearColor = mathfunction.Color(1,0,0,0);
    -- self.rendernode = nil;
    -- self.renderbasenode = nil;
    self.mask_tex = self:LoadTexture("test:hair/standardface_hair.png")
end

--第一次Update的时候会调用Start
function HairColorBehavior:_OnStart()
  --self:Initialize();
end

function HairColorBehavior:_OnAwake(def)
  self:Initialize();
end

function HairColorBehavior:SetResourceType(resourceId)
  self.rendernode:SetResourceType(resourceId);
  self.renderbasenode:SetResourceType(resourceId);
end

function HairColorBehavior:GetResourceType()
  return self.rendernode:GetResourceType();
end

function HairColorBehavior:GetSegmentComponent()
  if venuscore.isNil(self.hairSegment) then
    self.hairSegment = self.Node:GetComponent(apolloengine.Node.CT_CV_SEGMENT);
  else
    LOG("[hairSegment] exists!");
  end
end

function HairColorBehavior:Initialize()
  self.mask_tex = nil;
  self.mask_tex = self:LoadTexture("test:hair/standardface_hair.png")
  self.color_tex = self:LoadTexture(self.Texture_path);
  self.lut_tex = self:LoadTexture(self.lut_map);

  local scene = self.Node:GetHostScene();

  local initial_width  = 360;
  local initial_height = 640;
  local offset = self.offset;
  self.bbox_render = quad_render(scene, self.sequence - offset, "hair_bbox_layer", "comm:documents/editor_shaders/haircolor/haircolor_boundingbox_rotate.material", initial_width, initial_height);
  self.haircolor_tex = self.bbox_render:GetResultImage();
 
  self.rendernode = haircolor_render(scene, self.Node, "render_kuai", "comm:documents/editor_shaders/haircolor/haircolor_changecolor_kuai.material");
  self.renderbasenode = haircolor_render(scene, self.Node, "render_base", "comm:documents/editor_shaders/haircolor/haircolor_changecolor_base.material");--apollonode.QuadNode();

  -- self.renderbasenode = apollonode.QuadNode();
  -- self.rendernode = apollonode.QuadNode();
  
  -- self.renderbasenode:CreateResource(venuscore.IFileSystem:PathAssembly("comm:documents/haircolor/material/haircolor_changecolor_base.material"), true);
  -- self.rendernode:CreateResource(venuscore.IFileSystem:PathAssembly("comm:documents/haircolor/material/haircolor_changecolor_kuai.material"), true);

  self.renderbasenode:SetShow(false);
  self.rendernode:SetShow(false);
  print("[Hair seg Render] create success ");

  self:GetSegmentComponent();
  self.recognition = self.Node:GetComponent(apolloengine.Node.CT_CV_RECOGNITION);

  self.rendernode:SetParameter("TEXTURE_TO_COLOR",self.haircolor_tex);
  self.rendernode:SetParameter("TEXTURE_MASK",self.mask_tex);
  self.rendernode:SetParameter("BIRGHTNESS",mathfunction.vector1(2 - self.Bright));
  self.rendernode:SetParameter("STRENGTH",mathfunction.vector1(self.Strength));
  self.rendernode:SetParameter("MASKRATIO",mathfunction.vector1(self.Mask_ratio));
  self.rendernode:SetParameter("ISPURECOLOR",mathfunction.vector1(self.Color_mode));
  self.rendernode:SetParameter("PURECOLOR",mathfunction.vector4(self.ClearColor:x(), self.ClearColor:y(), self.ClearColor:z(), self.ClearColor:w()));

  self.renderbasenode:SetParameter("TEXTURE_TO_COLOR",self.haircolor_tex);
  self.renderbasenode:SetParameter("TEXTURE_MASK",self.mask_tex);
  self.renderbasenode:SetParameter("MASKRATIO",mathfunction.vector1(self.Mask_ratio));
  self.renderbasenode:SetParameter("BLEND_MODE", mathfunction.vector1(self.Overlay_mode));
  self.renderbasenode:SetParameter("BlendOpacity", mathfunction.vector1(self.Blend_opacity));
  self.renderbasenode:SetParameter("ISPURECOLOR",mathfunction.vector1(self.Color_mode));
  self.renderbasenode:SetParameter("PURECOLOR",mathfunction.vector4(self.ClearColor:x(), self.ClearColor:y(), self.ClearColor:z(), self.ClearColor:w()));
  self.renderbasenode:SetParameter("_LutMap", self.lut_tex);
  

  self.initialized = true;

end

function HairColorBehavior:LoadTexture(texture_path)
  local texture = apolloengine.TextureEntity();
  texture:PushMetadata(apolloengine.TextureFileMetadata(
                                 apolloengine.TextureEntity.TU_STATIC,
                                 apolloengine.TextureEntity.PF_AUTO,
                                 1, false,
                                 apolloengine.TextureEntity.TW_REPEAT,
                                 apolloengine.TextureEntity.TW_REPEAT,
                                 apolloengine.TextureEntity.TF_LINEAR,
                                 apolloengine.TextureEntity.TF_LINEAR,
                                 venuscore.IFileSystem:PathAssembly(texture_path)));
  texture:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
  texture:CreateResource();
  return texture;
end

function HairColorBehavior:_OnDestroy()
  if self.rendernode ~= nil then
    self.Node:DetachNode(self.rendernode.node);
    self.rendernode:Destroy();
    self.rendernode = nil;
  end

  if self.renderbasenode ~= nil then
    self.Node:DetachNode(self.renderbasenode.node);
    self.renderbasenode:Destroy();
    self.renderbasenode = nil;
  end

  if self.bbox_render ~= nil then
    self.bbox_render:Clear()
    self.bbox_render = nil;
  end

  self.mask_tex = nil;
  self.color_tex = nil;
  self.lut_tex = nil;
  self.haircolor_tex = nil;
  self.hairSegment = nil;
  self.recognition = nil;

  self.initialized = false;
end

function HairColorBehavior:UpdateBboxRender(bbox, roll)
  self.bbox_render:PreUpdate(self.sequence - self.offset);

  local mask_size = self.mask_tex:GetSize();
  local scale = self.Scale
  local uv = mathfunction.vector2(self.U, self.V);
  local scaler_updated  = self.bbox_render:Update(mask_size, bbox, roll, scale, uv);
  self.bbox_render:SetParameter("TEXTURE_DIFFUSE", self.color_tex);
  self.haircolor_tex = self.bbox_render:GetResultImage();
end

function  HairColorBehavior:UpdateHairColorRender(isEditor)
  self.renderbasenode:SetShow(false);
  self.rendernode:SetShow(false);
  self.rendernode.render:SetRenderOrder(self.offset);
  self.renderbasenode.render:SetRenderOrder(self.offset);
  if self.Default_mode then 
    self.rendernode:SetShow(true);
    self.rendernode:SetParameter("isEditor",mathfunction.vector1(isEditor));
    self.rendernode:SetParameter("TEXTURE_TO_COLOR",self.haircolor_tex);
    self.rendernode:SetParameter("TEXTURE_MASK",self.mask_tex);
    self.rendernode:SetParameter("BIRGHTNESS",mathfunction.vector1(2 - self.Bright));
    self.rendernode:SetParameter("STRENGTH",mathfunction.vector1(self.Strength));
    self.rendernode:SetParameter("MASKRATIO",mathfunction.vector1(self.Mask_ratio));
    self.rendernode:SetParameter("ISPURECOLOR",mathfunction.vector1(self.Color_mode));
    self.rendernode:SetParameter("PURECOLOR",mathfunction.vector4(self.ClearColor:x(), self.ClearColor:y(), self.ClearColor:z(), self.ClearColor:w()));
  else
    self.renderbasenode:SetShow(true);
    self.renderbasenode:SetParameter("isEditor",mathfunction.vector1(isEditor));
    self.renderbasenode:SetParameter("TEXTURE_TO_COLOR",self.haircolor_tex);
    self.renderbasenode:SetParameter("TEXTURE_MASK",self.mask_tex);
    self.renderbasenode:SetParameter("MASKRATIO",mathfunction.vector1(self.Mask_ratio));
    self.renderbasenode:SetParameter("BLEND_MODE", mathfunction.vector1(self.Overlay_mode));
    self.renderbasenode:SetParameter("BlendOpacity", mathfunction.vector1(self.Blend_opacity));
    self.renderbasenode:SetParameter("ISPURECOLOR",mathfunction.vector1(self.Color_mode));
    self.renderbasenode:SetParameter("PURECOLOR",mathfunction.vector4(self.ClearColor:x(), self.ClearColor:y(), self.ClearColor:z(), self.ClearColor:w()));
    self.renderbasenode:SetParameter("_LutMap", self.lut_tex);
  end
end


function HairColorBehavior:_OnLateUpdate(def)
    if not self.initialized then
        print("[hairSegment] not initialized");
        return;
    end

    if not venuscore.isNil(self.hairSegment) then
      self.bbox_render:SetShow(false);
      self.renderbasenode:SetShow(false);
      self.rendernode:SetShow(false);
      self.rendernode.render:SetRenderOrder(self.offset);
      self.renderbasenode.render:SetRenderOrder(self.offset);
      self.recognition = self.Node:GetComponent(apolloengine.Node.CT_CV_RECOGNITION);

      self.mask_tex = self.hairSegment:GetMask();
      local bbox = self.hairSegment:GetDataResult();
      local results = self.recognition:GetResult();
      local roll = 0;
      if results[cv.RecognitionComponent.cvFace] ~= nil then
        facerets = results[cv.RecognitionComponent.cvFace][1];
        if facerets~=nil then
          roll = facerets[106*2+9];
        end
      end
      
      if roll > 90 or roll < -90 then
        return
      end

      local bbox_v = mathfunction.vector4(bbox:Get(1):x(), bbox:Get(1):y(), bbox:Get(2):x(),bbox:Get(2):y());
      self:UpdateBboxRender(bbox_v, roll);
      self:UpdateHairColorRender(0.0);
    end
      
end



--编辑器回调属性Get、Set
function HairColorBehavior:GetTexturePath()
  return self.Texture_path;
end

function HairColorBehavior:SetTexturePath(value)
  self.Texture_path = value;
  self.color_tex = nil;
  self.color_tex = self:LoadTexture(self.Texture_path);
end

-- function HairColorBehavior:_Clear()
--   if self.rendernode then
--     self.Node:DetachNode(self.rendernode.node);
--     self.rendernode:Destroy();
--     self.rendernode = nil;
   
--   end

--   if self.renderbasenode then
--     self.Node:DetachNode(self.renderbasenode.node);
--     self.renderbasenode:Destroy();
--     self.renderbasenode = nil;
   
--   end

--   self.mask_tex = nil;
--   self.color_tex = nil;
--   self.lut_tex = nil;
--   self.haircolor_tex = nil;
-- end


function HairColorBehavior:GetStrength()
  return self.Strength;
end

function HairColorBehavior:SetStrength(value)
  self.Strength = value;
end

function HairColorBehavior:GetBright()
  return self.Bright;
end

function HairColorBehavior:SetBright(value)
  self.Bright = value;
end

function HairColorBehavior:GetU()
  return self.U;
end

function HairColorBehavior:SetU(value)
  self.U = value;
end

function HairColorBehavior:GetV()
  return self.V;
end

function HairColorBehavior:SetV(value)
  self.V = value;
end

function HairColorBehavior:GetScale()
  return self.Scale;
end

function HairColorBehavior:SetScale(value)
  self.Scale = value;
end


function HairColorBehavior:GetMaskRatio()
  return self.Mask_ratio;
end

function HairColorBehavior:SetMaskRatio(value)
  self.Mask_ratio = value;
end

function HairColorBehavior:GetBlendOpacityMode()
  return self.Blend_opacity;
end

function HairColorBehavior:SetBlendOpacityMode(value)
  self.Blend_opacity = value;
end

function HairColorBehavior:GetColorMode()
  return self.Color_mode;
end

function HairColorBehavior:SetColorMode(value)
  self.Color_mode = value;
end

function HairColorBehavior:GetOverlayMode()
  return self.Overlay_mode;
end

function HairColorBehavior:SetOverlayMode(value)
  self.Overlay_mode = value;
  if value >= 22 then
    --self.Overlay_mode = 22;
    local lut_mode = value - 22.0;
    if lut_mode == 0 then
      self.lut_map = "comm:documents/make_up/lut/darken.png";
      self.lut_tex = self:LoadTexture(self.lut_map);
    elseif lut_mode == 1 then
      self.lut_map = "comm:documents/make_up/lut/dark.png";
      self.lut_tex = self:LoadTexture(self.lut_map);
    elseif lut_mode == 2 then
      self.lut_map = "comm:documents/make_up/lut/lighten.png";
      self.lut_tex = self:LoadTexture(self.lut_map);
    elseif lut_mode == 3 then
      self.lut_map = "comm:documents/make_up/lut/lineardodge.png";
      self.lut_tex = self:LoadTexture(self.lut_map);
    elseif lut_mode == 4 then
      self.lut_map = "comm:documents/make_up/lut/light.png";
      self.lut_tex = self:LoadTexture(self.lut_map);
    elseif lut_mode == 5 then
      self.lut_map = "comm:documents/make_up/lut/div.png";
      self.lut_tex = self:LoadTexture(self.lut_map);
    end
  end
end

HairColorBehavior:MemberRegister("Default_mode");
HairColorBehavior:MemberRegister("offset");
HairColorBehavior:MemberRegister("ClearColor");

HairColorBehavior:MemberRegister("Strength",
  venuscore.ScriptTypes.FloatType(
    0, 1,
    HairColorBehavior.GetStrength,
    HairColorBehavior.SetStrength
));

HairColorBehavior:MemberRegister("Bright",
  venuscore.ScriptTypes.FloatType(
    0, 2,
    HairColorBehavior.GetBright,
    HairColorBehavior.SetBright
));

HairColorBehavior:MemberRegister("U",
  venuscore.ScriptTypes.FloatType(
    -1, 1,
    HairColorBehavior.GetU,
    HairColorBehavior.SetU
));

HairColorBehavior:MemberRegister("V",
  venuscore.ScriptTypes.FloatType(
    -1, 1,
    HairColorBehavior.GetV,
    HairColorBehavior.SetV
));

HairColorBehavior:MemberRegister("Scale",
  venuscore.ScriptTypes.FloatType(
    0, 2,
    HairColorBehavior.GetScale,
    HairColorBehavior.SetScale
));

HairColorBehavior:MemberRegister("Mask_ratio",
  venuscore.ScriptTypes.FloatType(
    0, 5,
    HairColorBehavior.GetMaskRatio,
    HairColorBehavior.SetMaskRatio
));

HairColorBehavior:MemberRegister("Texture_path",
  venuscore.ScriptTypes.FilePathType(
    apolloengine.TextureEntity:RTTI(),
    HairColorBehavior.GetTexturePath,
    HairColorBehavior.SetTexturePath
));

HairColorBehavior:MemberRegister("Color_mode",
  venuscore.ScriptTypes.ComboType(
    {
      {
        key = "pure color",
        value = 1.0
      },
      {
        key = "texutre color",
        value = 2.0
      },
    },
    HairColorBehavior.GetColorMode,
    HairColorBehavior.SetColorMode
));

function HairColorBehavior:GetSegment()
  return self.hairSegment;
end

function HairColorBehavior:SetSegment(segment)
  self.hairSegment = segment;
end

HairColorBehavior:MemberRegister("hairSegment",
  venuscore.ScriptTypes.ReferenceType(
    cv.SegmentComponent:RTTI(),    
    HairColorBehavior.GetSegment,
    HairColorBehavior.SetSegment
)); 


HairColorBehavior:MemberRegister("Blend_opacity",
  venuscore.ScriptTypes.FloatType(
    0, 1,
    HairColorBehavior.GetBlendOpacityMode,
    HairColorBehavior.SetBlendOpacityMode
));
-- "Normal",       -- 正常
--     "Darken"..heavy,       -- 变暗
--     "Multiply",     -- 正片叠加
--     "Color_burn"..heavy,   -- 颜色加深

--     "Linear_burn"..heavy,  -- 线性加深
--     "Dark"..heavy,         -- 深色
--     "Lighten"..heavy,      -- 变亮
--     "Screen",       -- 滤色

--     "Color_dodge"..heavy,  -- 颜色减淡
--     "Linear_dodge"..heavy, -- 线性减淡(添加)
--     "Light"..heavy,        -- 线色
--     "Overlay"..heavy,      -- 叠加

--     "Soft_light"..heavy,   -- 柔光
--     "Hard_light"..heavy,   -- 强光
--     "Vivid_light"..heavy,  -- 亮光
--     "Linear_light"..heavy, -- 线性光

--     "Pin_light"..heavy,    -- 点光
--     "Hard_mix"..heavy,     -- 实色混合
--     "Difference"..heavy,   -- 差值
--     "Exclusion"..heavy,    -- 排除

--     "Subtract"..heavy,     -- 减去
--     "Divide"..heavy,       -- 划分

--     "Hue"..heavy,          -- 色相
--     "Saturation"..heavy,   -- 饱和度
--     "Color"..heavy,        -- 颜色
--     "Luminosity"..heavy,   -- 透明度
--     "Blend"..heavy,        -- 融合
HairColorBehavior:MemberRegister("Overlay_mode",
  venuscore.ScriptTypes.ComboType(
    {
      {
        key = "Normal", -- 正常
        value = 1.0
      },
      {
        key = "Darken", -- 变暗
        value = 22.0
      },
      {
        key = "Multiply",
        value = 2.0
      },
      {
        key = "Color_burn",
        value = 13.0
      },
      {
        key = "Linear_burn",
        value = 20.0
      },
      {
        key = "Dark",
        value = 22.0+1.0
      },
      {
        key = "Lighten",
        value = 22.0+2.0
      },
      {
        key = "Screen",
        value = 3.0
      },
      {
        key = "Color_dodge",
        value = 14.0
      },
      {
        key = "Linear_dodge",
        value = 22.0+3.0
      },
      {
        key = "Light",
        value = 22.0+4.0
      },
      {
        key = "Overlay",
        value = 12.0
      },
      {
        key = "Soft_light",
        value = 15.0
      },
      {
        key = "Hard_light",
        value = 10.0
      },
      {
        key = "Vivid_light",
        value = 11.0
      },
      {
        key = "Linear_light",
        value = 18.0
      },
      {
        key = "Pin_light",
        value = 17.0
      },
      {
        key = "Hard_mix",
        value = 16.0
      },
      {
        key = "Difference",
        value = 19.0
      },
      {
        key = "Exclusion", -- 正常
        value = 9.0
      },
      {
        key = "Subtract", -- 正常
        value = 21.0
      },
      {
        key = "Divide", -- 变暗
        value = 22.0+5.0
      },
      {
        key = "Hue",
        value = 4.0
      },
      {
        key = "Saturation",
        value = 5.0
      },
      {
        key = "Color",
        value = 7.0
      },
      {
        key = "Luminosity",
        value = 6.0
      },
      {
        key = "Blend",
        value = 8.0
      },
    },
    HairColorBehavior.GetOverlayMode,
    HairColorBehavior.SetOverlayMode
));


return HairColorBehavior;