local venuscore = require "venuscore"
local venusjson     = require "venusjson"
local apolloengine = require "apolloengine"
local defined = require "behavior.cartoon_behavior.defined"
local utils = require "behavior.cartoon_behavior.utils"

local FrameAnimationPlayBehavior = venuscore.VenusBehavior:extend("FrameAnimationPlayBehavior")
local CONTROLLER_SCRIPT = "load_behavior.lua"

function FrameAnimationPlayBehavior:new()
  FrameAnimationPlayBehavior.super.new(self)
  self.Config = ""
end

function FrameAnimationPlayBehavior:_OnAwake()
  if self.Node:HaveComponent(apolloengine.Node.CT_FRAME_PLAYER) then
    self.animation = self.Node:GetComponent(apolloengine.Node.CT_FRAME_PLAYER)
  end

  if self.Controller ~= nil then
    self:RegisterNode()
  end
  
  if self.Config ~= "" then
    self:LoadConfig()
  end
end

function FrameAnimationPlayBehavior:_OnStart()
end

function FrameAnimationPlayBehavior:_OnUpdate(delta)
  if self.switch_frames == nil then
    return
  end
  if self.frame_time ~= nil then
    if self.next_switch_index <= #self.switch_frames and self.switch_frames[self.next_switch_index] <= self.frame_time then
      self:Switch()
      LOG("FrameAnimationPlayBehavior: switch")
      self.next_switch_index = self.next_switch_index + 1
    end
    self.frame_time = self.frame_time + delta
  end
end

function FrameAnimationPlayBehavior:Play()
  self.frame_time = 0
  self.next_switch_index = 1
  if self.animation == nil then
    return
  end
  self.animation:Reset()
  self.playing = false
end

function FrameAnimationPlayBehavior:Switch()
  if self.animation == nil then
    return
  end
  if self.playing then
    self.animation:Stop()
  else
    self.animation:Play()
  end
  self.playing = not self.playing
end

function FrameAnimationPlayBehavior:GetStatus()
  return defined.animation_status.DONE
end

function FrameAnimationPlayBehavior:RegisterNode()
  local controller_behavior = utils:GetBehavior(self.Controller, CONTROLLER_SCRIPT)
  if controller_behavior ~= nil then
    controller_behavior:RegisterAnimationNode(self.Node)
  end
end

function FrameAnimationPlayBehavior:LoadConfig()
  local root = venusjson.LaodJsonFile(self.Config)
  self.switch_frames = root.frames
end

function FrameAnimationPlayBehavior:SetConfig(value)
  self.Config = value
  self:LoadConfig()
end

function FrameAnimationPlayBehavior:GetConfig()
  return self.Config
end

FrameAnimationPlayBehavior:MemberRegister(
  "Controller",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI(),    
    nil,
    function(thiz, value)
      thiz.Controller = value
      thiz:RegisterNode()
    end
  )
)

FrameAnimationPlayBehavior:MemberRegister("Config",  
  venuscore.ScriptTypes.FilePathType(
    {"json"},
    FrameAnimationPlayBehavior.GetConfig,
    FrameAnimationPlayBehavior.SetConfig))

FrameAnimationPlayBehavior:MemberRegister("Delay")

return FrameAnimationPlayBehavior