local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local optimization = require "optimization"
local collisionhandler = require "avatar.retarget.collisionhandler"
local cv = require "computervisionfunction"
local util = require "behavior.avatar_behavior.util"
local skelScriptPath = "scrs:behavior/avatar_behavior/skeleton_behavior.lua"


local SkeCubes = {}

table.insert( SkeCubes, "RARM" );
table.insert( SkeCubes, "RFOREARM" );
table.insert( SkeCubes, "LARM" );
table.insert( SkeCubes, "LFOREARM" );
table.insert( SkeCubes, "NECKNOSE" );
table.insert( SkeCubes, "NOSEHEAD" );

local AvatarUpperDepth = venuscore.VenusBehavior:extend("AvatarUpperDepth"); 

function AvatarUpperDepth:new()
    self.RootEstimate = optimization.RootEstimate();
    self.ReprojCorrect = optimization.ReprojCorrect();
    self.ReprojCorrect:SetBoneLengthWeight({0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05});
    self.ReprojCorrect:SetMinimizeCWeight({0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0});
    self.ReprojCorrect:SetMinimizeZWeight({0.5,0.03,0.03,0.5,0.03,0.03,0.5,0.03,0.03,0.5,0.03,0.03,0.03,0.03});
    self.ReprojCorrect:SetBonePair({{0,1},{1,2},{3,4},{4,5},{6,8},{7,8},{8,9},{9,10},{10,11}});

    self.boneMargin = {{1.8,1.3,1.0},{1.8,1.3,1.0},{1.8,1.3,1.0},{1.8,1.3,1.0},{1.8,1.3,1.0},{1.8,1.3,1.0},{1.8,1.3,1.0},{1.8,1.3,1.0},{2.3,1.3,1.0}};

    self.recogition=nil;
   
    self.parents = {0,1,2,0,4,5,0,0,0,0,10,11}

    self.RARM = nil;
    self.RFOREARM = nil;
    self.LARM = nil;
    self.LFOREARM = nil;
    self.NECKNOSE = nil;
    self.NOSEHEAD = nil;

    self.BODYUPPER = nil;
    self.BODYLOWER = nil;

    self.BodyUpperMargin = mathfunction.vector3(1.5,1.6,1.0);
    self.BodyLowerMargin = mathfunction.vector3(2.0,1.2,1.0);
    self.BoxScale = 10;

    self.camera=nil;

    self.trans = {};

end

function AvatarUpperDepth:GetCamera()
    return  self.camera;
end

function AvatarUpperDepth:SetCamera(camera)
    self.camera = camera;
end

function AvatarUpperDepth:GetRecognitionComponent()
    return  self.recognition;
end

function AvatarUpperDepth:SetRecognitionComponent(recognition)
    self.recognition = recognition;
end

function AvatarUpperDepth:UpdateCameraParam()
    if  self.camera==nil then
        return;
    end
    
    local resolution = self.camera.CameraResolution;
  
    local cx = 0.5*resolution:x();
    local cy = 0.5*resolution:y();


    local projectionmat = self.camera:GetProject();
    local fx = projectionmat.a11;
    local fy = projectionmat.a22;
    fx = fx * cx;
    fy = fy * cy;

    if math.abs(fx-fy)>0.01 then
        LOG("DIFF FOCUS DISTANCE"..fx.." "..fy);
    end
    
    self.RootEstimate:SetCameraParam(fx,fy,cx,cy);
    self.RootEstimate:SetContinueWeight(0.0);

    self.ReprojCorrect:SetCameraParam(fx,fy,cx,cy);
end

function AvatarUpperDepth:GetHumanPose()
    if self.recognition==nil then
        return;
    end
    local results = self.recognition:GetResult();
    if results == nil or
       results[cv.RecognitionComponent.cvUpperBodyPose2D] == nil or
       results[cv.RecognitionComponent.cvUpperBodyPose3D] == nil then
        return nil, nil, nil
    end
    
    local pose2d_raw = results[cv.RecognitionComponent.cvUpperBodyPose2D][1]; -- x1, y1, score1, x2, y2, score2, ...
    local pose3d_raw = results[cv.RecognitionComponent.cvUpperBodyPose3D][1]; -- x1, y1,     z1, x2, y2,     z2, ...
    local pose2d_ret = {};
    local score_ret = {};
    local pose3d_ret = {};
    for i = 1, 12 do
        pose2d_ret[i] = {pose2d_raw[(i-1)*3+1], pose2d_raw[(i-1)*3+2]};
        score_ret[i] = pose2d_raw[(i-1)*3+3];
        pose3d_ret[i] = {pose3d_raw[(i-1)*3+1], pose3d_raw[(i-1)*3+2], pose3d_raw[(i-1)*3+3]}
    end

    self:UpdateCameraParam();

    if self.lastroot==nil then
        self.lastroot = {0,0,-4.3}
     end
    
    self.RootEstimate:SetRootPose(mathfunction.vector3(self.lastroot[1],self.lastroot[2],self.lastroot[3]));
    self.RootEstimate:SetPose3D(pose3d_ret);
    self.RootEstimate:SetPose2D(pose2d_ret);
    self.lastroot = self.RootEstimate:Minimize();
    LOG("ROOT POSITION IS "..self.lastroot[1].." "..self.lastroot[2].." "..self.lastroot[3]);

    for i = 1, 12 do
        pose3d_ret[i][1] =  pose3d_ret[i][1]+self.lastroot[1];
        pose3d_ret[i][2] =  pose3d_ret[i][2]+self.lastroot[2];
        pose3d_ret[i][3] =  pose3d_ret[i][3]+self.lastroot[3];
    end

    if self.first==false or self.first==nil  then
        self.ReprojCorrect:SetLastPose3D(pose3d_ret);
    end
    self.first = true;
    self.ReprojCorrect:SetPose3D(pose3d_ret);
    self.ReprojCorrect:SetPose2D(pose2d_ret);
    pose3d_ret_tmp = self.ReprojCorrect:Minimize();
--[[
    for i = 1, 12 do
        LOG("3d POSITION IS "..pose3d_ret_tmp[i][1].." "..pose3d_ret_tmp[i][2].." "..pose3d_ret_tmp[i][3]);
    end]]
    pose3d_ret = pose3d_ret_tmp;
    self.ReprojCorrect:SetLastPose3D(pose3d_ret);
    return pose2d_ret, score_ret, pose3d_ret
end


function AvatarUpperDepth:_OnAwake()

  
end

function AvatarUpperDepth:Lerp(from,to,percent)
    local ret = mathfunction.vector3();
    ret.mx = (to.mx - from.mx)*percent+from.mx;
    ret.my = (to.my - from.my)*percent+from.my;
    ret.mz = (to.mz - from.mz)*percent+from.mz;
    return ret;
end

function AvatarUpperDepth:_OnUpdate(def)
    self.trans[1] = self.RARM ;
    self.trans[2] = self.RFOREARM ;
    self.trans[3] = self.LARM ;
    self.trans[4] = self.LFOREARM ;
    self.trans[5] =  self.NECKNOSE ;
    self.trans[6] =  self.NOSEHEAD ;

    local pos2d, scores, pos3d = self:GetHumanPose();
    if pos2d == nil or pos3d == nil then
        return;
    end
    local transidx = 1;
    for i =1 , #self.parents do
        if self.parents[i] ~= 0 then
            local mypos = mathfunction.vector3((pos3d[i][1]),(pos3d[i][2]),pos3d[i][3]);
            local paridx = self.parents[i]
            local parentpos = mathfunction.vector3((pos3d[paridx][1]),(pos3d[paridx][2]),pos3d[paridx][3]);
            local cubepos = (mypos+parentpos)/2;
            local dir = parentpos-mypos;
            local length = dir:Length();
            local otherscale = length/4;
            dir:NormalizeSelf();
            local rotation = mathfunction.Quaternion();
            rotation:AxisToAxis(mathfunction.vector3(0,0,1),dir);
            
            if self.trans[transidx] ~= nil then
              local margin = self.boneMargin[transidx];
              if margin~=nil then
                otherscale = otherscale*margin[1];
                length = length*margin[3]
              end
              self.trans[transidx]:SetLocalScale(mathfunction.vector3(otherscale*self.BoxScale,otherscale*self.BoxScale,length*self.BoxScale));
              self.trans[transidx]:SetLocalPosition(cubepos);
              self.trans[transidx]:SetLocalRotation(rotation);
              transidx= transidx+1
            end
        end
    end

    if self.BODYUPPER~=nil and  self.BODYLOWER~=nil   then
        local RSPos = mathfunction.vector3( pos3d[1][1],  pos3d[1][2],  pos3d[1][3]);
        local LSPos = mathfunction.vector3( pos3d[4][1],  pos3d[4][2],  pos3d[4][3]);
        local RHPos = mathfunction.vector3( pos3d[7][1],  pos3d[7][2],  pos3d[7][3]);
        local LHPos = mathfunction.vector3( pos3d[8][1], pos3d[8][2], pos3d[8][3]);
        
        local shoulderwidth = (RSPos - LSPos):Length();
        local hipwidth = (RHPos - LHPos):Length();

        local bodyvector = (RSPos+LSPos)/2 - (RHPos+LHPos)/2;
        local bodyheight = bodyvector:Length();
        local shouldervector = LSPos-RSPos;
        local hipvector = LHPos-RHPos;

        local hiprotate      =  util:ConstractRotationFromVector(hipvector:Normalize(),bodyvector:Normalize());
        local shoulderrotate =  util:ConstractRotationFromVector(shouldervector:Normalize(),bodyvector:Normalize());

        local hippos = (RHPos+LHPos)/2;
        local sholderpos = (RSPos+LSPos)/2;
        local modelhippos = self:Lerp(hippos,sholderpos,0.25);
        local modelshoulderpos = self:Lerp(sholderpos,hippos,0.25);

        self.BODYUPPER:SetLocalScale(mathfunction.vector3(shoulderwidth*self.BodyUpperMargin:x()*self.BoxScale,bodyheight/2*self.BodyUpperMargin:y()*self.BoxScale,shoulderwidth/3*self.BodyUpperMargin:z()*self.BoxScale));
        self.BODYUPPER:SetLocalPosition(modelshoulderpos);
        self.BODYUPPER:SetLocalRotation(shoulderrotate:ToQuaternion());

        self.BODYLOWER:SetLocalScale(mathfunction.vector3(hipwidth*self.BodyLowerMargin:x()*self.BoxScale,bodyheight/2*self.BodyLowerMargin:y()*self.BoxScale,hipwidth/3*self.BodyLowerMargin:z()*self.BoxScale));
        self.BODYLOWER:SetLocalPosition(modelhippos);
        self.BODYUPPER:SetLocalRotation(hiprotate:ToQuaternion());
    end
end

for i=1, #SkeCubes do
    AvatarUpperDepth:MemberRegister(SkeCubes[i],
    venuscore.ScriptTypes.ReferenceType(
    apolloengine.TransformComponent:RTTI()
  )); 
end

AvatarUpperDepth:MemberRegister("BODYUPPER",
venuscore.ScriptTypes.ReferenceType(
apolloengine.TransformComponent:RTTI()
)); 

AvatarUpperDepth:MemberRegister("BODYLOWER",
venuscore.ScriptTypes.ReferenceType(
apolloengine.TransformComponent:RTTI()
)); 

AvatarUpperDepth:MemberRegister("camera",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.CameraComponent:RTTI(),
    AvatarUpperDepth.GetCamera,
    AvatarUpperDepth.SetCamera 
)); 


AvatarUpperDepth:MemberRegister("recognition",
  venuscore.ScriptTypes.ReferenceType(
    cv.RecognitionComponent:RTTI(),
    AvatarUpperDepth.GetRecognitionComponent,
    AvatarUpperDepth.SetRecognitionComponent 
)); 

AvatarUpperDepth:MemberRegister("BodyUpperMargin");
AvatarUpperDepth:MemberRegister("BodyLowerMargin");

return AvatarUpperDepth;