--@author      : Yang Min
--@date        : 2021-02-20
--@description : lua script for face reshape with autotoucher function
--@version     : 1.0

local apolloengine  = require "apolloengine"
local apollonode    = require "apolloutility.apollonode"
local cv            = require "computervisionfunction"
local autotoucher   = require "autotoucherfunction"

local FaceReshape = {};

function FaceReshape:Create(layer_sequence, scene)

    self.initialized = false;

    self.CaptureInput = apolloengine.TextureEntity();
    self.CaptureInput:PushMetadata(apolloengine.TextureReferenceMetadata(apolloengine.DeviceResource.DEVICE_CAPTURE));
    self.CaptureInput:CreateResource();

    self.virtual_node   = apollonode.VirtualNode();
    local recognition   = self.virtual_node:CreateComponent(apolloengine.Node.CT_CV_RECOGNITION);
    recognition.Enable  = true;
    recognition.Mode    = cv.IVisionComponent.VIDEO;
    recognition.Type    = cv.RecognitionComponent.cvFace + cv.RecognitionComponent.cvForeheadDetection;
    recognition.ShareCV = true;
    recognition:SetTexture(self.CaptureInput);
    self.recognition    = recognition;

    self.autotoucher = autotoucher.AutoToucherManager();
    local res = self.autotoucher:InitRenderNode(scene, layer_sequence);

    if res > 0 then
        ERROR("[FaceReshape] InitRenderNode return value: "..res);
        self.initialized = false;
    end

    self.preUpdateResult = 0;
    self.updateResult    = 0;
    self.initialized     = true;
end

function FaceReshape:SetShow(isShow)
    self.autotoucher:SetShow(isShow);
end

function FaceReshape:PreUpdate(def)

    if not self.initialized then
        ERROR("[FaceReshape] not initialized");
        return false;
    end

    if _KRATOSEDITOR then

    else
        self.virtual_node.node:Update(def);
    end

    local res = self.autotoucher:PreUpdateRenderNode(self.recognition);

    if res ~= 0 then
        if self.preUpdateResult ~= res then
            ERROR("[FaceReshape] PreUpdate return value: "..res);
        end
    end
    self.preUpdateResult = res;

    return (res == 0);
end

function FaceReshape:Update(texture, sequence)

    if not self.initialized then
        ERROR("[FaceReshape] not initialized");
        return false;
    end

    local res = self.autotoucher:UpdateRenderNode(self.recognition, texture, sequence);

    if res ~= 0 then
        if self.updateResult ~= res then
            ERROR("[FaceReshape] Update return value: "..res);
        end
    end
    self.updateResult = res;
end

function FaceReshape:SetFaceReshapeStrengthWithType(type, strength)

    self.autotoucher:SetFaceReshapeStrengthWithType(math.ceil(strength), type - 1);

    return true;
end

function FaceReshape:Destroy()

    if self.initialized == true then
        if self.virtual_node ~= nil then
            self.virtual_node:Destroy();
            self.virtual_node = nil;
        end

        if self.autotoucher ~= nil then
            self.autotoucher:ReleaseRenderNode();
            self.autotoucher = nil;
        end

        self.preUpdateResult = 0;
        self.updateResult    = 0;
        self.initialized = false;
    end

end

return FaceReshape;