local b3 = require 'behavior3.b3';
require 'behavior3.core.Decorator'
local mathfunction = require "mathfunction"
local modelscope = b3.Class("ModelScope", b3.Decorator)

function modelscope:ctor(properties, target)
  b3.Decorator.ctor(self)
	self.name = "ModelScope"  
  self.modelfile = properties.modelfile;
  self.physxfile = properties.physxfile;
  self.position = string.tovector(properties.position);
  self.rotation = mathfunction.vector3(0,0,0);
  self.scale = mathfunction.vector3(1,1,1);
  if properties.rotation~=nil then
    self.rotation = string.tovector(properties.rotation);
  end
  if properties.scale~=nil then
    self.scale = string.tovector(properties.scale);
  end
end


--新增的这种初始化接口，需要解决一个问题，同一个节点会调用多次初始化，
--那么被调用多次产生的多个数据如何储存的问题，而如何解决这个问题
--目前尽量不保存本地数据，通过将自身id传递给target取出对应数据来实现
function modelscope:init(tick)
  local board = tick.blackboard;
  local targetscope = board:get("targetscope");
  local modelscope = targetscope:LoadModel(self.modelfile, self.id);
  
  modelscope:SetLocalPosition(self.position);
  modelscope:SetLocalScale(self.scale);
  local quat = mathfunction.Quaternion();
  quat:YawPitchRoll((self.rotation:y()/180)*3.14,(self.rotation:x()/180)*3.14,(self.rotation:z()/180)*3.14);
  modelscope:SetLocalRotation(quat);

  local physicsscope = nil;
  if self.physxfile~= nil then
    physicsscope = targetscope:LoadPhysx(self.physxfile, self.id)
  end 
  local oldscope = board:get("modelscope");
  local oldsphysicscope = board:get("physicsscope");
  board:set("physicsscope", physicsscope);
  board:set("modelscope", modelscope);
  self.child:init(tick);
  board:set("modelscope", oldscope);
  board:set("modelscope", oldsphysicscope);
end

function modelscope:tick(tick)
	if not self.child then
		return b3.ERROR
	end
  local board = tick.blackboard;
  local targetscope = board:get("targetscope");
  local modelscope = targetscope:GetModel(self.id);  
  local physicsscope = targetscope:GetPhysics(self.id);  
  local oldscope = board:get("modelscope");
  local oldsphysicscope = board:get("physicsscope");
  board:set("physicsscope", physicsscope);
  board:set("modelscope", modelscope);
  local status = self.child:_execute(tick);
  board:set("modelscope", oldscope);
  board:set("physicsscope", oldsphysicscope);
	return status;
end

return modelscope;