local vc = require "venuscore"
local Object = require "classic"
require "utility"

local AsyncImageLoader = Object:extend()


function AsyncImageLoader:new(pathFormat, startNumber, count, loop)
  self.pathList = {}
  for i = 1, count do
    local path = string.format(pathFormat, startNumber + i - 1)
    path = vc.IFileSystem:PathAssembly(path)
    table.insert(self.pathList, path)
  end

  self.count = count
  self.loop = loop

  self.service = vc.IServicesSystem:Create("apolloutility.async_image_loader.image_loading_service")

  self.predictInterval = 1.0

  self.predictWindow = { 1.0, 1.0, 1.0, 1.0 }

  self.lastIndex = nil
end

function AsyncImageLoader:_RoundIndex(index)
  if self.loop then
    return math.fmod(index, self.count)
  else
    return index < 0 and 0 or (index >= self.count and self.count - 1 or index)
  end
end

function AsyncImageLoader:Load(index)

  index = self:_RoundIndex(index)

  if self.lastIndex ~= nil then
    local roundedInterval = math.fmod(
            math.fmod(index - self.lastIndex, self.count) + self.count,
            self.count)
    table.insert(self.predictWindow, roundedInterval)
    table.remove(self.predictWindow, 1)
    local intervalSum = 0
    for i = 1, #self.predictWindow do
      intervalSum = intervalSum + self.predictWindow[i]
    end
    self.predictInterval = intervalSum / #self.predictWindow
  end

  self.lastIndex = index

  local flooredIndex1 = math.floor(index)
  local flooredIndex2 = math.floor(index + self.predictInterval)

  flooredIndex2 = self:_RoundIndex(flooredIndex2)

  local path1 = self.pathList[flooredIndex1 + 1]
  local path2 = self.pathList[flooredIndex2 + 1]
  if path1 ~= nil then
    self.service:Push(path1, flooredIndex1)
  else
    ERROR("path1 is nil: index = " .. tostring(flooredIndex1))
  end
  if path2 ~= nil then
    self.service:Push(path2, flooredIndex2)
  else
    ERROR("path2 is nil: index = " .. tostring(flooredIndex2))
  end

  return self.service:Pop(flooredIndex1)

end

return AsyncImageLoader
