

#SHADER_DEFINE SHVertexLight
    FUNCTION_INPUT =
    {
        { CAMERA_VIEW,                HIGH,    MAT4,        "in_ViewMatrix"},
        { CAMERA_VIEWPROJ,						HIGH,    MAT4,    "in_ViewPorj" },
        { LOCALWORLD_ROTATION,				HIGH,    MAT3,        "in_WorldRotation" },
        { ATTRIBUTE_NORMAL,					HIGH,    VEC3,        "in_Normal" },
    }

    FUNCTION_OUTPUT =
    {
        { AMBIENT_COLOR,		HIGH,		VEC3,		"outSH" },
    }
#SHADER_CODE
    vec4 out_NormalWS;
    out_NormalWS.xyz = (in_WorldRotation * in_Normal);
    out_NormalWS.xyz = normalize(out_NormalWS.xyz);
    out_NormalWS.w = 1.0;

    vec3 outSH = vec3(0.0, 0.0, 0.0);
    vec4 SHAr = vec4(0.005, 0.026, 0.026, 0.129);
    vec4 SHAg = vec4(0.006, 0.053, 0.019, 0.104);
    vec4 SHAb = vec4(0.006, 0.064, 0.017, 0.098);

    vec4 SHBr = vec4(0.005, -0.014, -0.007, -0.015);
    vec4 SHBg = vec4(0.000, -0.009, -0.003, -0.012);
    vec4 SHBb = vec4(-0.001, -0.006, -0.003, -0.012);

    vec4 SHC = vec4(-0.030, -0.020, -0.017, 1.000);

    outSH.x = dot(SHAr.xyzw, out_NormalWS.xyzw);
    outSH.y = dot(SHAg.xyzw, out_NormalWS.xyzw);
    outSH.z = dot(SHAb.xyzw, out_NormalWS.xyzw);

    vec4 vB = out_NormalWS.xyzz * out_NormalWS.yzzx;
    vec3 x1;
    x1.x = dot(SHBr,vB);
    x1.y = dot(SHBg,vB);
    x1.z = dot(SHBb,vB);
    x1.xyz += SHC.xyz * (out_NormalWS.x*out_NormalWS.x - out_NormalWS.y * out_NormalWS.y);
    outSH.xyz += x1.xyz;
    outSH.xyz = max(outSH.xyz, vec3(0.0, 0.0, 0.0));
    outSH.xyz = pow(outSH.xyz, vec3(0.41666666, 0.41666666, 0.41666666)) * vec3(1.0549999, 1.0549999, 1.0549999) + vec3(-0.055, -0.055, -0.055);
    outSH.xyz = max(outSH.xyz, vec3(0.0, 0.0, 0.0)) * 1.05;
#END_CODE
#END_DEFINE

#SHADER_DEFINE SHPixelLight
    FUNCTION_INPUT =
    {
       { AMBIENT_COLOR,		HIGH,		VEC3,		"outSH" },
    }

    FUNCTION_OUTPUT =
    {
        { AMBIENT_COLOR,		HIGH,		VEC3,		"shAmbient" },
    }
#SHADER_CODE
    vec3 shAmbient = outSH;
#END_CODE
#END_DEFINE