//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in
//	all copies or substantial portions of the Software. And the logo of
//	Bohge Engine shall be displayed full screen for more than 3 seconds
//	when the software is started. Copyright holders are allowed to develop
//	game edit based on Bohge Engine, The edit must be released under the MIT
//	open source license if it is going to be published. In no event shall
//	copyright holders be prohibited from using any code of Bohge Engine
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////

// 输出纹理坐标 等于 输入纹理坐标
#SHADER_DEFINE Hair2DCoordinate
    FUNCTION_INPUT =
    {
        { ATTRIBUTE_COORDNATE0,            MEDIUM,    VEC2,        "in_Coordinate0" },
    }

    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,            MEDIUM,    VEC2,        "out_Coordinate" },
    }
#SHADER_CODE
    mediump vec2 out_Coordinate = in_Coordinate0;

#END_CODE
#END_DEFINE


//输出在世界空间下的顶点属性
//输出两个变换矩阵
#SHADER_DEFINE HairTransform
    FUNCTION_INPUT =
    {
        { CAMERA_VIEWPROJ,						HIGH,    MAT4,        "in_ViewPorj" },
        { LOCALWORLD_TRANSFORM,				HIGH,    MAT4,        "in_Transfrom" },
        { LOCALWORLD_ROTATION,				HIGH,    MAT3,        "in_WorldRotation" },
        { ATTRIBUTE_POSITION,					HIGH,    VEC4,        "in_Position" },
        { ATTRIBUTE_NORMAL,						HIGH,    VEC3,        "in_Normal" },
				{	ATTRIBUTE_TANGENT,					HIGH,    VEC3,        "in_Tangent"},
        { CAMERA_WORLDPOSITION,		    HIGH,    VEC3,	      "in_CameraPosition" },
    }
    FUNCTION_OUTPUT =
    {
        { SCREENSPACE_POSITION,     	HIGH,    VEC4,        "out_Position" },
				{ WORLDSPACE_POSITION,        HIGH,    VEC3,        "out_PositionWS" },
        { WORLDSPACE_NORMAL,         	HIGH,    VEC3,        "out_NormalWS" },
        { ATTRIBUTE_TANGENT,         	HIGH,    VEC3,        "out_TangentWS" },
        { WORLDSPACE_VIEWDIRECTION,	  HIGH,	   VEC3,	      "out_ViewDirection" },
    }
#SHADER_CODE
		vec4 out_Position = in_ViewPorj * in_Transfrom * in_Position;

		vec3 out_PositionWS  = vec3(in_Transfrom * in_Position);
    vec3 out_NormalWS = (in_WorldRotation * in_Normal);
    vec3 out_TangentWS = (in_WorldRotation * in_Tangent);

    vec3 out_ViewDirection =  (in_CameraPosition - out_PositionWS);

#END_CODE
#END_DEFINE


//计算人偶眼睛的直接光照
#SHADER_DEFINE HairLighting
    FUNCTION_INPUT =
    {
        { ATTRIBUTE_COORDNATE0,	  MEDIUM,	   VEC2,				 "texcoord0" },
        {	ATTRIBUTE_TANGENT,			HIGH,      VEC3,         "tangent" },
        { WORLDSPACE_NORMAL,      HIGH,      VEC3,         "in_Normal" },
        { WORLDSPACE_VIEWDIRECTION,	  HIGH,	 VEC3,	       "in_View" },
        { BASE_COLOR,             MEDIUM,    VEC4,         "baseColor" },
        { DISTURB_INTENSITY,      MEDIUM,    FLOAT,        "DistrubIntensity" },
        { FRESNEL,                MEDIUM,    FLOAT,        "Fresnel" },

        { LIGHT1DIR,              HIGH,         VEC3,          "Light1Dir"},
        { LIGHT1COLOR,            HIGH,         VEC3,          "Light1Color"},
        { LIGHT1INTENSITY,        HIGH,         FLOAT,         "Light1Intensity"},

         { LIGHT2DIR,              HIGH,         VEC3,          "Light2Dir"},
        { LIGHT2COLOR,            HIGH,         VEC3,          "Light2Color"},
        { LIGHT2INTENSITY,        HIGH,         FLOAT,         "Light2Intensity"},

        {SHADE_COLOR,             HIGH,         VEC3,          "shadeColor"},

        { SHIFT1,                 MEDIUM,    FLOAT,        "shift1" },
        { SHIFT2,                 MEDIUM,    FLOAT,        "shift2" },
        { SMOOTHNESS1,            MEDIUM,    FLOAT,        "smoothness1" },
        { SMOOTHNESS2,            MEDIUM,    FLOAT,        "smoothness2" },
        { SPECULAR_COLOR1, 			  MEDIUM,    VEC3,				 "DefSpecular1"},
        { SPECULAR_COLOR2, 			  MEDIUM,    VEC3,				 "DefSpecular2"},
        { TEXTURE_DIFFUSE,				NONE,			 TEXTURE2D,	   "diffuseTex" },
        { TEXTURE_SPECULAR,				NONE,			 TEXTURE2D,	   "specularTex" },
        { SURFACE_COLOR,				  HIGH,	        FLOAT,		"ShadowMask" },
        { AMBIENT_COLOR,		    HIGH,		      VEC3,		"shAmbient" },
    }

    FUNCTION_OUTPUT =
    {
        { SURFACE_COLOR,				HIGH,	        VEC4,	    	"finalColor" },
    }
#SHADER_CODE

  float shadowed = ShadowMask;

  if(!gl_FrontFacing){
    in_Normal = -in_Normal;
  }

  vec4 albedo = texture2D(diffuseTex, texcoord0);
  vec3 vLight = (Light1Dir);
  vec3 vLight2 = (Light2Dir);
  vec3 vNormal = normalize(in_Normal);
  vec3 vView = normalize(in_View);

  float smoothness;
  {
    smoothness = 1.0 - smoothness2;
    float smt_2 = smoothness*smoothness;
    float smt_4 = smt_2*smt_2;
    smt_4 = max(smt_4, 9.9999997e-05);
    smoothness = 2.0 / smt_4 - 2.0;
    smoothness = max(smoothness, 9.9999997e-05);
  }

  vec3 shiftNormal1 = (tangent - vNormal*vec3(shift2));
  shiftNormal1 = normalize(shiftNormal1);

  vec3 vHalf = normalize(vView + vLight);
  float HdotS1 = dot(vHalf, shiftNormal1);
  float mhds = (1.0 - HdotS1*HdotS1);
  mhds = max(mhds, 0.0);
  float tmp = pow(sqrt(mhds), smoothness);

  vec4 specColor = texture2D(specularTex, texcoord0);
  float sy = specColor.y*tmp;
  vec3 specular1 = DefSpecular2 * vec3(sy);

  float sw = specColor.w*2.0 - 1.0;
  sw = sw*DistrubIntensity + shift1;
  vec3 shiftNormal2 = (tangent + sw*vNormal);
  shiftNormal2 = normalize(shiftNormal2);
  float HdotS2 = dot(vHalf, shiftNormal2);

  vec4 smoothShading = vec4(1.0) - vec4(shadeColor, smoothness1);
  sw = smoothShading.w*smoothShading.w;
  float sw_2 = sw*sw;
  sw_2 = max(sw_2, 9.9999997e-05);
  sw_2 = 2.0 / sw_2 - 2.0;
  float sw_4 = max(sw_2, 9.9999997e-05);
  mhds = max(1.0 - HdotS2*HdotS2, 0.0);
  vec3 specular2 = DefSpecular1*pow(sqrt(mhds), sw_4);

  vec3 compositeColor = specular1+ specular2;
  compositeColor = compositeColor * specColor.xyz;
  compositeColor = compositeColor * Light1Color;

  float VDotN = dot(vView, vNormal);
  VDotN = clamp(VDotN, 0.0, 1.0);
  VDotN = 1.0 - VDotN;
  float v_2 = VDotN*VDotN;
  float v_5 = v_2*v_2*VDotN;
  float mfresnel = smoothness1 * 0.6 + Fresnel;
  mfresnel = min(mfresnel, 1.0);
  float minusFrn = 1.0- mfresnel;
  mfresnel = v_5*minusFrn + mfresnel;

  compositeColor = compositeColor * vec3(mfresnel);
  compositeColor = compositeColor * specColor.xyz;

  // back diffuse
  float minusL2dotN = dot(-vLight2, vNormal);
  minusL2dotN = clamp(minusL2dotN, 0.0, 1.0);

  float LdotN = dot(vLight, vNormal);
  float L2dotN = dot(vLight2, vNormal);
  L2dotN = clamp(L2dotN, 0.0, 1.0);

  vec3 lightSpec = vec3(specColor.y) * Light2Color * Light2Intensity;
  lightSpec = vec3(shadowed) * lightSpec;
  vec3 halfLightSpec = lightSpec*vec3(0.5);
  halfLightSpec = halfLightSpec*vec3(L2dotN);
  vec3 baseTone = baseColor.xyz * albedo.xyz;
  vec3 baseTone2 = baseTone*baseTone;
  vec3 backDiffuse = halfLightSpec*baseTone2;
  vec3 toneNormalizer = backDiffuse + vec3(1.0);
  backDiffuse = backDiffuse/toneNormalizer;
  backDiffuse *= vec3(L2dotN);

  // front diffuse
  float maxldotn = max(minusL2dotN, abs(LdotN));
  maxldotn = maxldotn * shadowed;
  maxldotn = min(maxldotn, 1.0);
  vec3 frontDiffuse = smoothShading.xyz * vec3(maxldotn) + shadeColor;

  frontDiffuse = frontDiffuse*Light1Color*Light1Intensity + shAmbient;
  frontDiffuse = frontDiffuse*baseTone2;

  vec3 finalDiffuse = frontDiffuse + backDiffuse;

  float transparency = albedo.w*baseColor.w;
  vec4 finalColor = vec4((compositeColor + finalDiffuse), transparency);

#END_CODE
#END_DEFINE


// 指定片元位置
#SHADER_DEFINE VertexOutput
    FUNCTION_INPUT =
    {
        { SCREENSPACE_POSITION,        HIGH,    VEC4,    "in_ScreenPosition" },
    }
    FUNCTION_OUTPUT = { }
#SHADER_CODE
    gl_Position = in_ScreenPosition;
#END_CODE
#END_DEFINE

//输出到片元
#SHADER_DEFINE FragmentOutput

    FUNCTION_INPUT =
    {
      { SURFACE_COLOR,                  MEDIUM,   VEC4,         "color"},
    }
    FUNCTION_OUTPUT = { }

#SHADER_CODE
		gl_FragColor = color;

#END_CODE
#END_DEFINE
