

#SHADER_DEFINE ConstIn

	FUNCTION_INPUT = 
	{
	}
	FUNCTION_OUTPUT =
	{
    { EASING_VALUE,           MEDIUM, FLOAT,  "out_EasingV"},
	}

#SHADER_CODE	
    float out_EasingV = 0.0;
#END_CODE
#END_DEFINE

#SHADER_DEFINE ConstOut

	FUNCTION_INPUT = 
	{
	}
	FUNCTION_OUTPUT =
	{
    { EASING_VALUE,           MEDIUM, FLOAT,  "out_EasingV"},
	}

#SHADER_CODE	
    float out_EasingV = 0.0;
#END_CODE
#END_DEFINE

#SHADER_DEFINE LinearIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { EASING_VALUE,           MEDIUM, FLOAT,  "out_EasingV"},
	}

#SHADER_CODE	
    float out_EasingV = in_Progress;
#END_CODE
#END_DEFINE

#SHADER_DEFINE LinearOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { EASING_VALUE,           MEDIUM, FLOAT,  "out_EasingV"},
	}

#SHADER_CODE	
    float out_EasingV = in_Progress;
#END_CODE
#END_DEFINE


#SHADER_DEFINE SineIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { EASING_VALUE,           MEDIUM, FLOAT,  "out_EasingV"},
	}

#SHADER_CODE	
    float out_EasingV = sin((in_Progress - 1.0) * 1.5707963267948966) + 1.0;
#END_CODE
#END_DEFINE

#SHADER_DEFINE SineOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { EASING_VALUE,           MEDIUM, FLOAT,  "out_EasingV"},
	}

#SHADER_CODE	
    float out_EasingV = sin(in_Progress * 1.5707963267948966);
#END_CODE
#END_DEFINE


#SHADER_DEFINE ExponentialIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { EASING_VALUE,           MEDIUM, FLOAT,  "out_EasingV"},
	}

#SHADER_CODE	

  float out_EasingV = 0.0;
  if (in_Progress == 0.0)
    out_EasingV = in_Progress;
  else
    out_EasingV = pow(2.0,10.0 * (in_Progress - 1.0));
#END_CODE
#END_DEFINE

#SHADER_DEFINE ExponentialOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { EASING_VALUE,           MEDIUM, FLOAT,  "out_EasingV"},
	}

#SHADER_CODE	
  float out_EasingV = 0.0;
  if (in_Progress == 1.0)
    out_EasingV = in_Progress;
  else
    out_EasingV = 1.0 - pow(2.0, -10.0 * in_Progress);
#END_CODE
#END_DEFINE


#SHADER_DEFINE BackIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { EASING_VALUE,           MEDIUM, FLOAT,  "out_EasingV"},
	}

#SHADER_CODE	
  float out_EasingV = pow(in_Progress,3.0) - in_Progress * sin(in_Progress * 3.141592653589793);
#END_CODE
#END_DEFINE

#SHADER_DEFINE BackOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { EASING_VALUE,           MEDIUM, FLOAT,  "out_EasingV"},
	}

#SHADER_CODE	
  float f = 1.0 - in_Progress;
  float out_EasingV = 1.0 - (pow(f, 3.0) - f * sin(f * 3.141592653589793));
#END_CODE
#END_DEFINE

#SHADER_DEFINE BounceOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { EASING_VALUE,           MEDIUM, FLOAT,  "out_EasingV"},
	}

#SHADER_CODE	
  const float a_out = 4.0 / 11.0;
  const float b_out = 8.0 / 11.0;
  const float c_out = 9.0 / 10.0;

  const float ca_out = 4356.0 / 361.0;
  const float cb_out = 35442.0 / 1805.0;
  const float cc_out = 16061.0 / 1805.0;

  float t2_out = in_Progress * in_Progress;
  
  float out_EasingV = 0.0;
  if (in_Progress < a_out)
  {
    out_EasingV = 7.5625 * t2_out;
  }
  else
  {
    if (in_Progress < b_out)
    {
      out_EasingV = 9.075 * t2_out - 9.9 * in_Progress + 3.4;
    }
    else
    {
      if (in_Progress < c_out)
      {
        out_EasingV = ca_out * t2_out - cb_out * in_Progress + cc_out;
      }
      else
      {
        out_EasingV = 10.8 * in_Progress * in_Progress - 20.52 * in_Progress + 10.72;
      }
    }
  }

#END_CODE
#END_DEFINE

#SHADER_DEFINE BounceIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { EASING_VALUE,           MEDIUM, FLOAT,  "out_EasingV"},
	}

#SHADER_CODE	

  float t = 1.0 - in_Progress;
  const float a = 4.0 / 11.0;
  const float b = 8.0 / 11.0;
  const float c = 9.0 / 10.0;

  const float ca = 4356.0 / 361.0;
  const float cb = 35442.0 / 1805.0;
  const float cc = 16061.0 / 1805.0;

  float t2 = t * t;
  
  float out_EasingV = 0.0;
  if (t < a)
  {
    out_EasingV = 7.5625 * t2;
  }
  else
  {
    if (t < b)
    {
      out_EasingV = 9.075 * t2 - 9.9 * t + 3.4;
    }
    else
    {
      if (t < c)
      {
        out_EasingV = ca * t2 - cb * t + cc;
      }
      else
      {
        out_EasingV = 10.8 * t * t - 20.52 * t + 10.72;
      }
    }
  }
  out_EasingV = 1.0 - out_EasingV;

#END_CODE
#END_DEFINE



