
#DEFPARAMS
TEXTURE_DIFFUSE = { "tex diffuse", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "Simple"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 position : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float4 position : SV_POSITION;
	float2 uv : TEXCOORD0;
};

float3x3 LOCALWORLD_ROTATION;
Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;

v2f vert(appdata v)
{
	v2f o;
	float4 positionWS = mul(v.position, LOCALWORLD_TRANSFORM);
	o.position = mul(positionWS, CAMERA_VIEWPROJ);
	o.position = UniformNDC(o.position);
	o.uv = v.uv;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	mainColor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv);
}
ENDCG
#END
