local apolloengine = require "apolloengine"
local apollonode = require "apolloutility.apollonode"
local videodecet = require "videodecet"
local soundplayer = require "soundplayer"
local faceinfo = require "videodecet.faceinfo"
local define = require "videodecet.defined"
local mathfunction = require "mathfunction"
local math = require "math"
local venuscore = require "venuscore"

local dollymain={};
dollymain.time=0;
dollymain.t=1;

--缩放时间点列表(未出现触发效果)
--dollymain.basetime = {0.0,0.05,1.0,1.5,1.55,1.6,1.65,3.0,3.5,3.55,4.0,4.55,4.6,5.05,5.1,5.15,5.25};
dollymain.basetime = {0.0,4.0,8.0,15.0};
--与缩放时间点相对应的尺寸(未出现触发效果)
dollymain.scale =    {0.0,0.25,0.5,0.5}
--dollymain.scale = {0.2,0.3,0.35,0.4,0.7,0.7,1.12,1.17,1.22,1.55,1.55,1.6,2.0,2.0,2.0,2.0,2.0};
--划分几个关键时间点（dollymain.basetime的size-1）
dollymain.part = 3;
--触发效果直接放大尺寸
dollymain.triggerscale = 1.6;
dollymain.flag = false;
dollymain.soundplayerDetect = {0,0};

function dollymain:_arrayToVec2(pt)
  return mathfunction.vector2(pt[1],pt[2]);
end

function dollymain:Initialize(camera,config)
  self.time = 0;
  self.maincamera = camera;
  self.post = self.maincamera:CreatePostEffect();
  self.lpath = venuscore.IFileSystem:PathAssembly("docs:filter/tuijingmouth/filter/resource");
  
  self.post:CreateResource(self.lpath.."/dolly.lua"); 
  self.post:RegisterParameter("UNIFORM_CENTER",self.lpath.."/material/dolly.material");
  self.post:RegisterParameter("UNIFORM_SCALE",self.lpath.."/material/dolly.material");
  self.post:RegisterParameter("UNIFORM_AMP",self.lpath.."/material/dolly.material");
  self.post:UNIFORM_SCALE(mathfunction.vector1(1.0));
  self.post:UNIFORM_CENTER(mathfunction.vector2(0.0, 0.0)); 
  self.post:UNIFORM_AMP(mathfunction.vector1(0.0)); 
  
  self.soundpath = "ress:"..config.filter.Sound.SoundA;
  self.spath = venuscore.IFileSystem:PathAssembly(self.soundpath);
  --LOG(venuscore.IFileSystem:PathAssembly(self.soundpath));
  self.soundplayerDetect[1] = soundplayer();
  local res = self.soundplayerDetect[1]:LoadSound(self.spath);
  self.soundplayerDetect[1]:PlaySound(1);
  
  self.soundpath = "ress:"..config.filter.Sound.SoundB;
  self.spath = venuscore.IFileSystem:PathAssembly(self.soundpath);
  --LOG(venuscore.IFileSystem:PathAssembly(self.soundpath));
  self.soundplayerDetect[2] = soundplayer();
  res = self.soundplayerDetect[2]:LoadSound(self.spath);
  
  videodecet:ActiveActions({define.triggerType.OpenMouth});
  --self.maincamera:AttachPostEffect(self.post);
end

function dollymain:Update(def)
  self.time = self.time + def;
  local faces = videodecet:GetFaces();
  local maxFaceNum = 1;
  if faces and faces[1] then
    local faceinfo = faces[1];
    local keypoints = faceinfo:GetKeypointArray();
    self.center = (self:_arrayToVec2(keypoints[78])+self:_arrayToVec2(keypoints[75]))*0.5;
  else
    self.center = mathfunction.vector2(0.0, 0.0);
  end
  local newscale = 0.0;
  --触发条件检测
  local people = videodecet: GetActions();
  local peoplenum = 0;
  if not self.flag and people then
    peoplenum = #people;
  end
  for i = 1, peoplenum, 1 do
    local action = people[i];
    local actionnum = 0;
    if action then
      actionnum = #action;
    end
    for k = 1, actionnum, 1 do
      local actioninfo = action[k];
      local actiontype = actioninfo:GetActionID();
      if actiontype == define.triggerType.OpenMouth then
         self.flag = true;
         self.soundplayerDetect[1]:StopSound();
         self.soundplayerDetect[2]:PlaySound(1);
         break;
      end
    end
    if self.flag then
      --LOG("break");
      break;
    end
    
  end
  
  if self.flag then
    newscale = self.triggerscale;
    self.post:UNIFORM_SCALE(mathfunction.vector1(newscale));
    self.post:UNIFORM_CENTER(self.center);
    self.post:UNIFORM_AMP(mathfunction.vector1(1.0)); 
    return;
  end

  if self.time>=self.basetime[self.t]then
    self.t =self.t+1;
  end
  if(self.time>=self.basetime[self.part]) then
    --self.time = 0.0;
    self.t = 1;
    newscale = 0.5;
  else
    newscale = (self.scale[self.t]-self.scale[self.t-1])*(self.time-self.basetime[self.t-1])/(self.basetime[self.t]-self.basetime[self.t-1])+self.scale[self.t-1];
  end
  self.post:UNIFORM_SCALE(mathfunction.vector1(newscale));
  self.post:UNIFORM_CENTER(self.center);
  self.post:UNIFORM_AMP(mathfunction.vector1(0.0)); 
end

function dollymain:OnRecordStart()
  
  self.time = 0;
  self.t = 1;
  self.flag = false;
  self.soundplayerDetect[2]:StopSound();
  self.soundplayerDetect[1]:StopSound();
  self.soundplayerDetect[1]:PlaySound(1);
  
end

function dollymain:Exit()
  
  self.post:Disable();
  self.maincamera:DeletePostEffect(self.post);
  self.post = nil;
  self.soundplayerDetect[1]:StopSound();
  self.soundplayerDetect[2]:StopSound();
  self.soundplayerDetect[1] = nil;
  self.soundplayerDetect[2] = nil;
  
end

return dollymain;
