local apolloengine = require "apolloengine"
local venuscore = require "venuscore"



local Halfcolor = {}

Halfcolor.Half = 0;
Halfcolor.Mat = 0;
Halfcolor.Queue = 200;

function Halfcolor:Initialize(host, size)
  
  self.UNIFORM_CENTER= apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_CENTER");
  self.UNIFORM_SPILT= apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_SPILT");
  self.UNIFORM_SATURATION= apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_SATURATION");
  self.UNIFORM_LUMINANCE= apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_LUMINANCE");
  
  local pathout = venuscore.IFileSystem:PathAssembly("docs:filter/halfcolor/filter/resource/material/halfcolor.material"); 
  self.Mat = host:CreateMaterial(pathout);
  self.Half = host:CreateRenderObject();
  
  return self.Queue;
end

function Halfcolor:Resizeview(size)
end

function Halfcolor:Process(context, Original, Scene, Output)
  --Output:PushRenderTarget();
  --Output:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
  context:BeginRenderPass(Output,apolloengine.RenderTargetEntity.CF_COLOR);
  self.Mat:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));
	--self.Half:Draw(pipeline);
  context:Draw(self.Half,self.Mat);
  context:EndRenderPass();
end

return Halfcolor;