local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local SetDefaultStateCommand = CommandBase:extend("SetDefaultStateCommand");

function SetDefaultStateCommand:new(uuid, smsId, stateId)
    SetDefaultStateCommand.super.new(self);
    self._uuid = uuid;
    self._smsId = smsId;
    self._stateId = stateId;
end

function SetDefaultStateCommand:DoIt()
    self:BeginCmd();
    if self._uuid then
      local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
      if ani then
        local state = ani:GetStateById(0, self._stateId);
        if state then
           ani:SetDefaultState(self._smsId, state);
        end
      end
    end
    self:EndCmd();
end

function SetDefaultStateCommand:Undo()
    self:BeginCmd();
    self:EndCmd();
end

return SetDefaultStateCommand;