local venusjson = require "venusjson"
local venuscore = require "venuscore"
local torch = require "torch"

local utility = {}

function utility.GMM_Json2Tensor(jsonfile, tensorfile)
  local gmm = venusjson.LaodJsonFile(jsonfile)
  local w = gmm["weights"];
  local cs = gmm["covars"];  
  for i, c in ipairs(cs) do
    cs[i] = torch.Tensor(c);
  end
  local ms = gmm["means"];
  for i, m in ipairs(ms) do
    ms[i] = torch.Tensor({m});
    LOG(ms[i]:size());
  end  
  local fullpath = venuscore.IFileSystem:PathAssembly(tensorfile);
  torch.save(fullpath, gmm);
  LOG("finish");
end


return utility;