local Types = require "venuscore.rtti.types"
local libvenuscore = require "libvenuscore"
local AE = require "apolloengine"
local BD = require "bluecore.bluedefined"
local BlueDynamicNode = require "bluecore.base.blue_dynamic_node"
local BlueNodeRef = BlueDynamicNode:extend();

-- FIXME(hhl) 目前ReferenceType这个不影响(反)序列化,只是用于Editor弹窗文件的过滤
BlueNodeRef:MemberRegister("refNode", Types.ReferenceType(AE.Node:RTTI()));
BlueNodeRef:MemberRegister("nodeName");




function BlueNodeRef:new(graph, node)

  BlueNodeRef.super.new(self, graph)

  self.refNode = node -- nil if deserialization
  --self.rtti = AE.Node:RTTI()
  --self.rttiName = AE.Node:RTTI():GetTypeName()
  self.nodeName = nil
  

  -- 实例的typeinfo! MemberRegister动态修改
  self.__typeinfos = {}
  local clazz = getmetatable(self)
  for k, v in pairs(clazz.__typeinfos) do
    self.__typeinfos[k] = v;
  end
end

function BlueNodeRef:_OnDuplicate()

  local luaPath = self[BD.LUA_CLASS_PATH];
  local clazz = require(luaPath);
  local bluePrintNode = clazz(self.graph, self:GetRef()); --创造实例
  bluePrintNode[BD.LUA_CLASS_PATH] = luaPath;
  bluePrintNode:EditorCreate();
  return bluePrintNode;

end


function BlueNodeRef:_Setup()

  --LOG("[BlueNodeRef] rttiName = "..tostring(self.rttiName))

  local new_type = Types.ReferenceType(AE.Node:RTTI())
  new_type:SetKeyname("refNode");
  self.__typeinfos["refNode"] = new_type

end


function BlueNodeRef:_OnDeserialize()
  BlueNodeRef.super._OnDeserialize(self)

  --self.rtti = AE.Node:RTTI()
  self:_Setup()  -- reference类型 是要在node反序列化完 才设置的
end


function BlueNodeRef:_OnDeserializePost()
  BlueNodeRef.super._OnDeserializePost(self)
  if _KRATOSEDITOR then
    if libvenuscore.isNil(self.refNode) then
      WARNING("[_OnDeserializePost] self.refNode is nil")
      return
    end
    --assert(self.refNode, "[_OnDeserializePost] self.refNode is nil")
    LOG("BlueNodeRef rtti/2 "..tostring(self.refNode:GetTypeName()))
  end
end


function BlueNodeRef:_OnCompile()
  local isNil
  if BlueNodeRef.super._OnCompile(self) then
    isNil = libvenuscore.isNil(self.refNode)
  end
  if isNil then
    self.compileResult = "node is lost";
  end
  return not isNil
end

function BlueNodeRef:GetRef()
  return self.refNode
end

if _KRATOSEDITOR then

function BlueNodeRef:_OnCreateWithEditor()

  BlueNodeRef.super._OnCreateWithEditor(self);

  self.nodeName = self.refNode:GetTypeName()
  assert(self.refNode, "[BlueNodeRef] node is nil")
  --assert(self.rtti , "[BlueNodeRef] rtti not found")
  self[BD.OUTPUTS_INFO][1].rtti = self.refNode:RTTI()
  self[BD.OUTPUTS_INFO][1].name = self.nodeName
  self[BD.OUTPUTS_INFO][1].tips = "Reference of "..self.nodeName

  LOG("[BlueNodeRef] nodeName "..tostring(self.nodeName))
  --LOG("[BlueNodeRef] rtti  "..tostring(self.rtti:GetTypeName()))

  self:_Setup();
end


function BlueNodeRef:_OnUpdateByEditor()
  BlueNodeRef.super._OnUpdateByEditor(self);
  if self:_OnCompile() then
    self.nodeName = self.refNode:GetName();
    self[BD.OUTPUTS_INFO][1].name = self.nodeName
  end
end

end

-- -- 运行时
function BlueNodeRef:Update(args)
end

function BlueNodeRef:GetOutputByIndex(index)
  return self.refNode
end


BlueNodeRef:RegisterOutput(1, AE.Node:RTTI(), "node", "reference of node", nil, false , nil);
BlueNodeRef:SetFunctionType(BD.REF_NODE);
BlueNodeRef:SetFunctionName("ref_node")

return BlueNodeRef