local Types = require "venuscore.rtti.types"
local RttiManager = require "venuscore.rtti.rttimanager"
local libvenuscore = require "libvenuscore"
local AE = require "apolloengine"
local BD = require "bluecore.bluedefined"
local BlueDynamicNode = require "bluecore.base.blue_dynamic_node"
local BlueCompRef = BlueDynamicNode:extend();

-- FIXME(hhl) 目前ReferenceType这个不影响(反)序列化,只是用于Editor弹窗文件的过滤
BlueCompRef:MemberRegister("comp", Types.ReferenceType(AE.LightComponent:RTTI()));
BlueCompRef:MemberRegister("rttiName");
BlueCompRef:MemberRegister("compName");

-- 当前实现:
--    删除Component之后,蓝图上对应节点不会删除,只会编译失败,dumper也会提示
--    由于删除Component没有通知,蓝图本身不会修改,所以编译按钮不会出现
--    没有执行输入 执行输出引脚
function BlueCompRef:new(graph, comp)

  BlueCompRef.super.new(self, graph)

  self.comp = comp -- may nil if deserialization
  self.rtti = nil
  self.compName = nil
  self.rttiName = nil

  -- 实例的typeinfo! MemberRegister动态修改
  self.__typeinfos = {}
  local clazz = getmetatable(self)
  for k, v in pairs(clazz.__typeinfos) do
    self.__typeinfos[k] = v;
  end
end


function BlueCompRef:_OnDuplicate()

  local luaPath = self[BD.LUA_CLASS_PATH];
  local clazz = require(luaPath);
  local bluePrintNode = clazz(self.graph, self:GetRef()); 
  bluePrintNode[BD.LUA_CLASS_PATH] = luaPath;
  bluePrintNode:EditorCreate();
  return bluePrintNode;

end

function BlueCompRef:_Setup()

  if _KRATOSEDITOR then LOG("[BlueCompRef] rttiName = "..tostring(self.rttiName)) end

  local new_type = Types.ReferenceType(self.rtti)
  new_type:SetKeyname("comp");
  self.__typeinfos["comp"] = new_type

end


function BlueCompRef:_OnDeserialize()
  BlueCompRef.super._OnDeserialize(self)

  self.rtti = RttiManager:GetRttiByName(self.rttiName)
  self:_Setup()  -- reference类型 是要在node反序列化完 才设置的
end


function BlueCompRef:_OnDeserializePost()
  BlueCompRef.super._OnDeserializePost(self)
  if _KRATOSEDITOR then
    if libvenuscore.isNil(self.comp) then
      WARNING("[_OnDeserializePost] self.comp is nil")
      return
    end
    --assert(self.comp, "[_OnDeserializePost] self.comp is nil")
    LOG("BlueCompRef rtti/2 "..tostring(self.comp:GetTypeName()))
  end
end


function BlueCompRef:_OnCompile()
  if BlueCompRef.super._OnCompile(self) then
    return not libvenuscore.isNil(self.comp)
  end
  return false
end

function BlueCompRef:GetRef()
  return self.comp
end

if _KRATOSEDITOR then

function BlueCompRef:_OnCreateWithEditor()

  BlueCompRef.super._OnCreateWithEditor(self);

  assert(self.comp, "[BlueCompRef] comp is nil")
  self.rtti = self.comp:RTTI();
  self.rttiName = self.rtti:GetTypeName();
  self.compName = self.comp:GetTypeName().."\n".."node: ".. self.comp:GetHostNode():GetName();

  assert(self.rtti , "[BlueCompRef] rtti not found")
  self[BD.OUTPUTS_INFO][1].rtti = self.rtti
  self[BD.OUTPUTS_INFO][1].name = self.compName
  self[BD.OUTPUTS_INFO][1].tips = "Reference of "..self.compName

  LOG("[BlueCompRef] compName "..tostring(self.compName))
  LOG("[BlueCompRef] rtti  "..tostring(self.rtti:GetTypeName()))

  self:_Setup();
end


function BlueCompRef:_OnUpdateByEditor()
  BlueCompRef.super._OnUpdateByEditor(self);
  if self:_OnCompile() then
    self.compName = self.comp:GetTypeName().."\n".."node: ".. self.comp:GetHostNode():GetName();
    self[BD.OUTPUTS_INFO][1].name = self.compName
  else
    self.compileResult = "component is lost";
  end
end

end

-- -- 运行时
function BlueCompRef:Update(args)
end

function BlueCompRef:GetOutputByIndex(index)
  return self.comp
end


BlueCompRef:RegisterOutput(1, AE.LightComponent:RTTI(), "component", "reference of component", nil, false , nil);
BlueCompRef:SetFunctionType(BD.COMPONENT_NODE);
BlueCompRef:SetFunctionName("ref_component")

return BlueCompRef