
local EventDispatcher = {};

EventDispatcher.AllEvents = {};
EventDispatcher.RegisterEventName = {};
EventDispatcher.AllRegisterEventNameList = {};
EventDispatcher.Callbacks = {};

--callbackInfo.blueSelf --调用函数的object
--callbackInfo.func --调用函数的地址

--C++component检测到就会马上push 然后执行  运行完毕销毁掉这个event
function EventDispatcher:PushEvent(event)
  table.insert(self.AllEvents,event);
  self:DispatchEvent(); -- TODO(hhl) 执行事件的时机
  self:ClearEvents();
end

function EventDispatcher:ClearEvents()
  self.AllEvents = {};
end

function EventDispatcher:ClearCallbacks()
  self.Callbacks = {};
end

--初始脚本就会调用 脚本文件被require就会被调用~~
--[[function EventDispatcher:RegisterEvent(rtti, name)
  if self.RegisterEventName[rtti] == nil then
    self.RegisterEventName[rtti] = {};
  end
  self.RegisterEventName[rtti][name] = name;
  self.AllRegisterEventNameList[name] = name;
  return name;
end]]--

--custom节点专用？？？？？
--[[function EventDispatcher:GetRegisterEvent(rtti)
  if rtti == nil then
    return self.AllRegisterEventNameList;
  end
  return self.RegisterEventName[rtti] or {};
end]]--

--component ID号    事件类型(停止/张嘴？/播放)  Update函数地址    Update调用者   参数
function EventDispatcher:RegisterCallback(staticID, eventType, func, blueSelf)
  self.Callbacks[staticID] = self.Callbacks[staticID] or {};
  self.Callbacks[staticID][eventType] = self.Callbacks[staticID][eventType] or {}

  local callbackInfo = setmetatable({}, { __mode = 'v' })
  callbackInfo.blueSelf = blueSelf
  callbackInfo.func = func --  对 blueSelf和生成的回调函数 的弱引用

  table.insert(self.Callbacks[staticID][eventType], callbackInfo)
end

function EventDispatcher:DeregisterCallback(blueprint)
  local emptyStaticId = {}
  for staticId, staticIdTbl in pairs(self.Callbacks) do
    local emptyEventType = {}
    for eventType, eventTypeTbl in pairs(staticIdTbl) do
      for i=#eventTypeTbl, 1, -1 do
        local callbackInfo = eventTypeTbl[i]
        if callbackInfo.blueSelf == blueprint then
          table.remove(eventTypeTbl, i)
        end
      end
      if next(eventTypeTbl) == nil then
        table.insert(emptyEventType, eventType);
      end
    end

    -- clear eventType table
    for _, eventType in pairs(emptyEventType) do
      --WARNING("clear eventType "..tostring(eventType)..", "..tostring(staticId));
      staticIdTbl[eventType] = nil
    end

    if next(staticIdTbl) == nil then
      table.insert(emptyStaticId, staticId);
    end
  end

  -- clear statidId table
  for _, staticId in pairs(emptyStaticId) do
    --WARNING("clear Callbacks staticId "..tostring(staticId));
    self.Callbacks[staticId] = nil ;
  end

end

-- 用于编辑器Run和Stop蓝图时确认是否清空
function EventDispatcher:CheckCallbackEmpty()
  for staticId, staticIdTbl in pairs(self.Callbacks) do
    for eventType, eventTypeTbl in pairs(staticIdTbl) do
      for _, callbackInfo in pairs(eventTypeTbl) do
        assert(callbackInfo==nil, "CheckCallbackEmpty fail")
        return false
      end
    end
  end
  return true ;
end

--该节点的输入componen状态是否有监听？
function EventDispatcher:HasCompListener(staticID)
  return self.Callbacks[staticID] ~= nil and next(self.Callbacks[staticID]) ~= nil
end

--该节点的component的某一个状态是否有监听？
function EventDispatcher:HasEventListener(staticID, eventType)
  --  call after HasCompListener return true
  return  self.Callbacks[staticID][eventType] ~= nil and next(self.Callbacks[staticID][eventType]) ~= nil
end

function EventDispatcher:GetEventListener(staticID)
  return  self.Callbacks[staticID];
end

--pushevent调用  运行update函数
function EventDispatcher:DispatchEvent()
  for _,event in pairs(self.AllEvents) do
    local id = event.staticID;        -- 代表发射事件的Compnonet
    local eventType = event.eventType;-- 代表事件的类型
    local params = event.params;      -- 代表GetResults->Result[n] 事件监听节点的返回参数 
    if self.Callbacks[id] ~= nil and self.Callbacks[id][eventType] ~= nil then
      local callbacks = self.Callbacks[id][eventType];
      for i =  #callbacks, 1, -1 do
      --for _, callbackInfo in ipairs(eventCallBackTable) do
        --eventCallBackTable的元素顺序是从子到父(蓝图Run的顺序从子到父寄存事件地址) 为了与Update从父到子一致 这里需要逆序调用
        local callbackInfo = callbacks[i];
        if callbackInfo.blueSelf ~= nil and callbackInfo.func ~= nil then
          --事件分发器不仅用于蓝图事件节点 也可用在behavior
          callbackInfo.func(callbackInfo.blueSelf, params);
          -- func is blueprint:onCompile -> self.EventEntries[name].func = function(self, ...)
        end
      end
    end
  end
end


return EventDispatcher;