
local BlueSingle = {}

local _gBlueDumper;
local _gBlueManager;
local _gSetupDone;
local _gWindowsystem;
local _gEditSystem;

-- 单例管理: 只能定义函数,函数外部不能依赖require任何lua

BlueSingle.GetDumper = function()
  _gBlueDumper = _gBlueDumper ~= nil and _gBlueDumper or require "bluecore.bluedumper"
 return _gBlueDumper
end

if _KRATOSEDITOR then

  BlueSingle.GetBlueManager = function()
    _gBlueManager = _gBlueManager ~= nil and _gBlueManager or require "bluecore.bluemanager"
    return _gBlueManager;
  end


  BlueSingle.GetWindowManager = function()
    _gWindowsystem = _gWindowsystem ~= nil and _gWindowsystem or require "window.editor.system.windowsystem"
    return _gWindowsystem
  end


  BlueSingle.GetEditorSystem = function()
    _gEditSystem = _gEditSystem ~= nil and _gEditSystem or require "window.editor.system.editsystem"
    return _gEditSystem;
  end
  
end

BlueSingle.init = function()

  if not _gSetupDone then

    LOG("BlueSingleInstance.init begin")

    _gSetupDone = true
    local libvenuscore = require "libvenuscore"
    local rttiWraperClass = libvenuscore.RttiWrapper
    local isTypeOrDriverTypeFunc = rttiWraperClass.isTypeOrDriverType;
    local isTypeFunc = rttiWraperClass.isType;

    rttiWraperClass.isTypeOrDriverType = function (self, other)
      --LOG("type(self) "..type(self)..", type(other) "..type(other))
      if type(other) == 'userdata' then
        return isTypeOrDriverTypeFunc(self, other)
      else
        return false
      end
    end

    rttiWraperClass.isType = function (self, other)
      --LOG("type(self) "..type(self)..", type(other) "..type(other))
      if type(other) == 'userdata' then
        return isTypeFunc(self, other)
      else
        return false
      end
    end

    rttiWraperClass.isArray = function(self) -- C++ RTTI没有这个
      return false ;
    end


    LOG("BlueSingleInstance.init done")
  end
end

return BlueSingle;
