local mf = require "mathfunction"
local BlueNode = require "bluecore.bluenode"
local Vec3MinusVec3Exec = BlueNode:extend();

---- 游戏运行模式
function Vec3MinusVec3Exec:new(...)
  Vec3MinusVec3Exec.super.new(self, ...)
end

function Vec3MinusVec3Exec:_OnUpdate(args)
  local one = args[1] ;
  local two = args[2] ;
  return one - two ;
end

---- 编辑器模式

Vec3MinusVec3Exec:RegisterInput(1, mf.vector3:RTTI(), "1", "向量(x,y,z)", mf.vector3(0.0,0.0,0.0));
Vec3MinusVec3Exec:RegisterInput(2, mf.vector3:RTTI(), "2", "向量(x,y,z)", mf.vector3(0.0,0.0,0.0));
Vec3MinusVec3Exec:RegisterOutput(1, mf.vector3:RTTI(), "-", "相减(x,y,z)");
Vec3MinusVec3Exec:SetFunctionName("vec3-vec3(exec)");

Vec3MinusVec3Exec:RegisterExecInput(1, "Exec", "执行");
Vec3MinusVec3Exec:RegisterExecOutput(1, "Next", "执行");

return Vec3MinusVec3Exec;