local BlueNode = require "bluecore.bluenode"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"

local Sigmoid = BlueNode:extend();

---- 游戏运行模式
function Sigmoid:new(...)
  Sigmoid.super.new(self, ...)
end

function Sigmoid:_OnUpdate(args)
  local res = 1.0/(1.0+math.exp(-10.0*(args[1]-0.5)));
  if args[2] then
    if res > 0.9999 then
      return 1.0;
    elseif res < 0.0001 then
      return 0.0;
    end
  end
  return res;

end

---- 编辑器模式

Sigmoid:RegisterInput(1, Types.FloatType, "x", "input", 0);
Sigmoid:RegisterInput(2, Types.BoolType, "limit", "逼近极限是否归为0/1", false);
Sigmoid:RegisterOutput(1, Types.FloatType, "y", "y=1.0/(1.0+exp(-10.0*(x-0.5)))");
Sigmoid:SetFunctionName("Sigmoid");
Sigmoid:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return Sigmoid;

