local BlueNode = require "bluecore.bluenode"
local EventDispatcher = require "bluecore.eventdispatcher"
local BlueDefined = require "bluecore.bluedefined"
local apolloengine = require "apolloengine"
local Types = require "venuscore.rtti.types"
local BlueSelf = require "bluecore.blueself"

local OnAniPlay = BlueNode:extend();


function OnAniPlay:new(...)
  OnAniPlay.super.new(self, ...)
  self.edge = true;
end

function OnAniPlay:_OnUpdate(eventParam)
  self.output = eventParam
end

function OnAniPlay:_OnNextBranch()
  if self.edge and not self.output.isEdge then 
    return 0
  else
    return 1
  end
end

function OnAniPlay:RegisterTriggerFunc(func, bluePrintSelf)

  self:_GetInput()

  self.edge = self.inputArgs[2];

  EventDispatcher:RegisterCallback(self.inputArgs[1]:GetContentPath(), BlueDefined.Event.AnimationEvent.Play, func, bluePrintSelf);
end


OnAniPlay:RegisterInput(1, apolloengine.AnimationComponent:RTTI(), "component", "监听组件", BlueSelf());
OnAniPlay:RegisterInput(2, Types.BoolType, "edge", "边缘触发", true);

OnAniPlay:RegisterExecOutput(1, "OnTrigger", "执行");

OnAniPlay:SetFunctionName("_OnAnimationPlay");

OnAniPlay:SetFunctionType(BlueDefined.EVENT_FUNCTION_NODE);

OnAniPlay:SetEventType(BlueDefined.EventType.RegisterCallback);

return OnAniPlay;

