local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local GoIfFlip = BlueNode:extend();
local EXEC_YES_PIN = 1
local EXEC_NO_PIN = 2

-- 状态翻转才执行
function GoIfFlip:new(...)
  GoIfFlip.super.new(self, ...)
  self.currentState = nil ;
  self.changed = false ;
end


-- 如果获取self.result的值 BlueNode:Update会避免执行当前节点
function GoIfFlip:_OnUpdate(args)

  if self.currentState == nil then
    self.currentState = args[2]
  end

  local inputState = args[1]
  if inputState ~= self.currentState then
    self.changed = true
    self.currentState = inputState
  else
    self.changed = false
  end
end

function GoIfFlip:_OnNextBranch()
  if self.changed then
    --self.changed = false -- blueprint会在update之后读取多次
    if self.currentState then
      return EXEC_YES_PIN
    else
      return EXEC_NO_PIN
    end
  else
    return 0
  end
end

function GoIfFlip:_OnReset()
  self.currentState = nil
  self.changed = false
end

GoIfFlip:RegisterInput(1, Types.BoolType, "status", "当前状态", false);
GoIfFlip:RegisterInput(2, Types.BoolType, "initial", "初始状态", false); --只在加载和重置后获取一次
GoIfFlip:RegisterExecInput(1, "exec", "Execute");
GoIfFlip:RegisterExecOutput(EXEC_YES_PIN, "Yes", "Yes");
GoIfFlip:RegisterExecOutput(EXEC_NO_PIN, "No", "No");

GoIfFlip:SetFunctionName("Go If Flip");

return GoIfFlip;

