local Types = require "venuscore.rtti.types"
local BlueNode = require "bluecore.bluenode"

local Gate = BlueNode:extend();

local EXEC_ENTER = 1
local EXEC_OPEN = 2
local EXEC_CLOSE = 3
local EXEC_TOGGLE = 4

---- 游戏运行模式
function Gate:new(...)
  Gate.super.new(self, ...)
  self.isClosed = nil
end

function Gate:Update(execIdx)
  if self.isClosed == nil then
    self:_GetInput();
    self.isClosed = self.inputArgs[1] or false
  end

  if execIdx == EXEC_ENTER then
    if not self.isClosed then -- open
      return 1;
    end
  elseif execIdx == EXEC_OPEN then
    self.isClosed = false
  elseif execIdx == EXEC_CLOSE then
    self.isClosed = true
  elseif execIdx == EXEC_TOGGLE then
    self.isClosed =  not self.isClosed
  else
    ERROR("Gate:Update out of range "..tostring(execIdx));
  end
  return
end


function Gate:_OnReset()
  self.isClosed = nil
end

---- 编辑器模式
Gate:RegisterInput(1, Types.BoolType, "Start Closed", "Start Closed", false);

Gate:RegisterExecInput(1, "exec", "Execute");
Gate:RegisterExecInput(2, "open", "open", true)
Gate:RegisterExecInput(3, "close", "close", true)
Gate:RegisterExecInput(4, "toggle", "toggle", true)

Gate:RegisterExecOutput(1, "Exit", "Exit");

Gate:SetFunctionName("Gate");

return Gate;

