local AE = require "apolloengine"
local mf = require "mathfunction"
local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"

local SetLocalEulerAngle = BlueNode:extend();

function SetLocalEulerAngle:new(...)
  SetLocalEulerAngle.super.new(self,...)
end

function SetLocalEulerAngle:_OnUpdate(args)
  local transform  = args[1];
  local isDegree = args[2];
  local vec3 = args[3]

  if isDegree then
    vec3 = mf.vector3(vec3:x() *math.pi/180.0, vec3:y() *math.pi/180.0,  vec3:z()*math.pi/180.0)
  end

  transform.LocalEularAngle = vec3
  return true;
end


SetLocalEulerAngle:RegisterInput(1, AE.TransformComponent:RTTI(), "target", "TransformComponent", BlueSelf());
SetLocalEulerAngle:RegisterInput(2, Types.BoolType, "is degree", "true:degree, false:radian ", true);
SetLocalEulerAngle:RegisterInput(3, mf.vector3:RTTI(), "angle", "vector(degree or radian)", mf.vector3(0, 0, 0));


SetLocalEulerAngle:RegisterExecInput(1, "exec", "执行");
SetLocalEulerAngle:RegisterExecOutput(1, "exec", "执行");

SetLocalEulerAngle:SetFunctionName("Set Local Euler Angle(vec3)");


return SetLocalEulerAngle;
