local AE = require "apolloengine"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"
local mf = require "mathfunction"

local GetLocalEulerAngleVec3 = BlueNode:extend();

function GetLocalEulerAngleVec3:new(...)
  GetLocalEulerAngleVec3.super.new(self, ...)
end

function GetLocalEulerAngleVec3:_OnUpdate(args)
  local transformTarget = args[1];
  local result = transformTarget.LocalEularAngle
  if args[2] then
    return mf.vector3(result:x()*180.0/math.pi, result:y()*180.0/math.pi, result:z()*180.0/math.pi);
  else
    return mf.vector3(result:x(), result:y(), result:z());
  end
end

GetLocalEulerAngleVec3:RegisterInput(1, AE.TransformComponent:RTTI(), "target", "TransformComponent组件", BlueSelf());
GetLocalEulerAngleVec3:RegisterInput(2, Types.BoolType, "is degree", "true:degree, false:radian ", true);
GetLocalEulerAngleVec3:RegisterOutput(1, mf.vector3:RTTI(), "vec3", "vec3");

GetLocalEulerAngleVec3:SetFunctionName("Get Local Euler Angle(vec3)");

return GetLocalEulerAngleVec3;

