local mathfunction = require "mathfunction"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local GetScriptValue = require "bluecore.base.get_script_value"
local GetScriptVector3 = GetScriptValue:extend();


---- 游戏运行模式
function GetScriptVector3:new(...)
  GetScriptVector3.super.new(self, ...)

end

function GetScriptVector3:_OnUpdate(args)

  local scriptIns = args[1];
  local para = args[2];  
  --return scriptIns[para];
  return scriptIns:GetScriptValue(para);
end



function GetScriptVector3:_IsRightType(key, value, scriptIns)
  return type(value) == "userdata" and value:RTTI() == mathfunction.vector3():RTTI();
end



GetScriptVector3:RegisterInput(1, Types.ScriptInsRefType, "Script_Instance", "behaviour", Types.NotNullType());
GetScriptVector3:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING); --instance可选的vector3变量

GetScriptVector3:RegisterOutput(1, mathfunction.vector3:RTTI(), "Vector3", "获取参数值");


GetScriptVector3:SetFunctionName("GetScriptVector3");


return GetScriptVector3 ;

