local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local BlueNode = require "bluecore.bluenode"
local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"

local SetTexQuad = BlueNode:extend();

function SetTexQuad:new(...)
  SetTexQuad.super.new(self, ...);
end

function SetTexQuad:_OnUpdate(args)
   
  local renderComponent = args[1];
	local indexStream  = apolloengine.IndicesStream();
	indexStream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
	indexStream:ReserveBuffer(6);
	indexStream:PushIndicesData(2);
	indexStream:PushIndicesData(1);
	indexStream:PushIndicesData(0);
	indexStream:PushIndicesData(1);
	indexStream:PushIndicesData(2);
	indexStream:PushIndicesData(3);
	renderComponent:ChangeIndexBuffer(indexStream);

	local vertexStream = renderComponent:GetVertexStream();
	vertexStream:Clear();
	vertexStream:ReserveBuffer(4);

	vertexStream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,mathfunction.vector2(0,1));
	vertexStream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,mathfunction.vector2(0,0));
	vertexStream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,mathfunction.vector2(1,1));
	vertexStream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,mathfunction.vector2(1,0));  
	local resolution = apolloengine.Framework:GetResolution();

	--local bottomleft = mathfunction.vector4(2.0*args[2].mx/resolution.mx-1.0, 2.0*(args[2].my-args[4])/resolution.my-1.0, 0, 1);
	--local topleft = mathfunction.vector4(2.0*args[2].mx/resolution.mx-1.0, 2.0*args[2].my/resolution.my-1.0, 0, 1);
	--local bottomright = mathfunction.vector4(2.0*(args[2].mx+args[3])/resolution.mx-1.0, 2.0*(args[2].my-args[4])/resolution.my-1.0, 0, 1); 
	--local topright = mathfunction.vector4(2.0*(args[2].mx+args[3])/resolution.mx-1.0, 2.0*args[2].my/resolution.my-1.0, 0, 1); 

  --local bottomleft = mathfunction.vector4(-1,-1,0,1);
  --local topleft = mathfunction.vector4(-1,1,0,1);
  --local bottomright = mathfunction.vector4(1,-1,0,1);
  --local topright = mathfunction.vector4(1,1,0,1);
  	
	local imagewidth = args[3]/resolution.mx;
	local imageheight = args[4]/resolution.my;
	local bottomleft = mathfunction.vector4(2.0*args[2].mx-1.0, 2.0*(args[2].my-imageheight)-1.0, 0, 1);
	local topleft = mathfunction.vector4(2.0*args[2].mx-1.0, 2.0*args[2].my-1.0, 0, 1);
	local bottomright = mathfunction.vector4(2.0*(args[2].mx+imagewidth)-1.0, 2.0*(args[2].my-imageheight)-1.0, 0, 1); 
	local topright = mathfunction.vector4(2.0*(args[2].mx+imagewidth)-1.0, 2.0*args[2].my-1.0, 0, 1); 
	

	vertexStream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,bottomleft);
	vertexStream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,topleft);
	vertexStream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,bottomright);
	vertexStream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,topright);
	renderComponent:ChangeVertexBuffer(vertexStream);


end

--传入顶点是0 1坐标   左上角为原点   传入宽和高是分辨率的宽和高....
SetTexQuad:RegisterInput(1, apolloengine.RenderComponent:RTTI(), "target", "(文字图片)渲染组件", BlueSelf());
SetTexQuad:RegisterInput(2, mathfunction.vector2:RTTI(), "position", "左上角位置", mathfunction.vector2(0, 0));
SetTexQuad:RegisterInput(3, Types.IntType, "width", "宽", 50);
SetTexQuad:RegisterInput(4, Types.IntType, "height", "高", 50);

SetTexQuad:RegisterExecInput(1, "exec", "Execute");

SetTexQuad:RegisterExecOutput(1, "exec", "Execute");

SetTexQuad:SetFunctionName("SetTexQuad");

return SetTexQuad;
