local Types = require "venuscore.rtti.types"
local cv = require "computervisionfunction"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local BD = require "bluecore.bluedefined"

local HasResultIdx = BlueNode:extend();

---- 游戏运行模式
function HasResultIdx:new(...)
  HasResultIdx.super.new(self, ...)
end

function HasResultIdx:_OnUpdate(args)
  local comp = args[1];
  local index = args[2] > 0 and args[2] or 1
  return comp ~= nil and comp:HasResultWithIndex(index)
end

---- 编辑器模式
HasResultIdx:RegisterInput(1, cv.RecognitionComponent:RTTI(), "target", "RecognitionComponent组件", BlueSelf());
HasResultIdx:RegisterInput(2, Types.IntType, "index", "序号(从1开始)", 1);
HasResultIdx:RegisterOutput(1, Types.BoolType, "hasResult", "是否有结果?");
HasResultIdx:SetFunctionName("Has Result With Index?");
HasResultIdx:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return HasResultIdx;

