local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local SetPostEffectValue = require "bluecore.base.set_posteffect_value"
local SetPostEffectVector2 = SetPostEffectValue:extend();


---- 游戏运行模式
function SetPostEffectVector2:new(...)
  SetPostEffectVector2.super.new(self, ...)
end


function SetPostEffectVector2:_IsRightType(value)
  return type(value) == "userdata" and value:RTTI() == mathfunction.vector2:RTTI();
end



SetPostEffectVector2:RegisterInput(1, Types.CameraPostEffectRefType, "postEffect", "后处理", Types.NotNullType());
SetPostEffectVector2:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING); 
SetPostEffectVector2:RegisterInput(3, mathfunction.vector2:RTTI(), "ParaValue", "参数值", mathfunction.vector2(1.0,1.0));


SetPostEffectVector2:RegisterExecInput(1, "exec", "执行");

SetPostEffectVector2:RegisterExecOutput(1, "exec", "执行");

SetPostEffectVector2:SetFunctionName("SetPostEffectVector2");


return SetPostEffectVector2 ;

