local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local GetPostEffectValue = require "bluecore.base.get_posteffect_value"
local GetPostEffectVector1 = GetPostEffectValue:extend();


---- 游戏运行模式
function GetPostEffectVector1:new(...)
  GetPostEffectVector1.super.new(self, ...)
end




function GetPostEffectVector1:_IsRightType(value)
  local vec1 = type(value) == "userdata" and value:RTTI() == mathfunction.vector1:RTTI();
  --local scalar = type(value) == "number";
  return vec1;
end



GetPostEffectVector1:RegisterInput(1, Types.CameraPostEffectRefType, "postEffect", "后处理", Types.NotNullType());
GetPostEffectVector1:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING); 

GetPostEffectVector1:RegisterOutput(1, mathfunction.vector1:RTTI(), "ParaValue", "参数值");

GetPostEffectVector1:SetFunctionName("GetPostEffectVector1");


return GetPostEffectVector1 ;

