local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local BlueNode = require "bluecore.bluenode"
local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"

local SetParamInt = BlueNode:extend();

function SetParamInt:new(...)
    SetParamInt.super.new(self, ...);
end

function SetParamInt:_OnUpdate(args)
    args[1]:SetIntValue(args[2], args[3]);
end

SetParamInt:RegisterInput(1, apolloengine.AnimationComponent:RTTI(), "target", "动画组件", BlueSelf());
SetParamInt:RegisterInput(2, Types.StringType, "ParamName", "参数名字", "");
SetParamInt:RegisterInput(3, Types.IntType, "Int Value", "Int", 0);
SetParamInt:RegisterExecInput(1, "exec", "Execute");
SetParamInt:RegisterExecOutput(1, "exec", "Execute");
SetParamInt:SetFunctionName("SetParamInt");

return SetParamInt;
