local AE = require "apolloengine"
local BD = require "bluecore.bluedefined"
local BlueSelf = require "bluecore.blueself"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local venuscore = require "libvenuscore"
local BluePinInfo = require "bluecore.bluepininfo"

local PlayWithParams = BlueNode:extend();



function PlayWithParams:new(...)
  PlayWithParams.super.new(self, ...);
end

function PlayWithParams:_OnUpdate(args)
  local comp = args[1] ;
  local ani = args[2] ;
  local type = args[3] ;
  comp:Play(ani, type);
end

function PlayWithParams:_GetCompOnPin1()

  if #self.inputs[1].links ~= 0 then

    local bluePinLink = self.inputs[1].links[1]
    local otherNode = self.graph:GetNode(bluePinLink.nodeUid);

    if otherNode:GetFunctionType() == BD.COMPONENT_NODE and otherNode.comp == nil then
      self.compileResult = BD.EHINT.NOT_LINK_TO_COMP
      return nil
    end

    if venuscore.isNil(otherNode.comp) then
      self.compileResult = BD.EHINT.COMP_LOST
      return nil
    end

    return otherNode.comp

  else
    self.compileResult = BD.EHINT.PIN_1_EMPTY;
  end
  return nil
end

function PlayWithParams:_IsCompPin(pin)
  return pin.pinType == BD.PIN_DATA_INPUT and pin.argId == 1
end

function PlayWithParams:_SetupInstanceInfoTable()
  -- 不需要序列化 但需要单独修改一个引脚的infoTable
  -- override  infoTable
  local staticExecInputsInfo = self.infoTable[BD.PIN_EXEC_INPUT]
  local staticExecOutputsInfo = self.infoTable[BD.PIN_EXEC_OUTPUT]
  local staticDataOutputsInfo = self.infoTable[BD.PIN_DATA_OUTPUT]
  local staticDataInputsInfo = self.infoTable[BD.PIN_DATA_INPUT]
  self.infoTable = {}
  self.infoTable[BD.PIN_DATA_INPUT] = {}
  self.infoTable[BD.PIN_DATA_OUTPUT] = staticDataOutputsInfo
  self.infoTable[BD.PIN_EXEC_INPUT]  = staticExecInputsInfo
  self.infoTable[BD.PIN_EXEC_OUTPUT] = staticExecOutputsInfo


  self.myUnFixComboType = Types.ComboType:extend();
  self.myUnFixComboType:SetData({},{});

  local pinInfo = staticDataInputsInfo[1]
  self.infoTable[BD.PIN_DATA_INPUT][1] =  staticDataInputsInfo[1]
  pinInfo = staticDataInputsInfo[2]
  self.infoTable[BD.PIN_DATA_INPUT][2] = BluePinInfo(BD.PIN_DATA_INPUT, pinInfo.argId, self.myUnFixComboType, pinInfo.name,pinInfo.tips,pinInfo.default,pinInfo.delAble, pinInfo.groupName);
  pinInfo = staticDataInputsInfo[3]
  self.infoTable[BD.PIN_DATA_INPUT][3] =  staticDataInputsInfo[3]
end


function PlayWithParams:_Reset()
  -- 引脚类型
  self.myUnFixComboType:SetData({},{});
  -- 字面值
  self.inputs[2].literal = ""
end


function PlayWithParams:_OnDeserialize()
  PlayWithParams.super._OnDeserialize(self);
  self:_SetupInstanceInfoTable();
end


function PlayWithParams:_OnCompile()
  -- pin1 有连接 && 必须是引用component,
  self.compileResult = nil
  if PlayWithParams.super._OnCompile(self) then
    local comp = self:_GetCompOnPin1();
    if comp then
      if comp:HasAnimation(self.inputs[2].literal) then
        return true
      else
        self.compileResult = BD.EHINT.ANI_NOT_EXIST;
      end
    end
  end
  return false
end

---- 编辑器模式

if _KRATOSEDITOR then

  function PlayWithParams:_OnLink(selfPin, otherNode, otherPin)
    if self:_IsCompPin(selfPin) then
      local comp = self:_GetCompOnPin1();
      if comp then
        local animations = comp:GetAnimations();
        local anis = {}
        for ani, _ in pairs(animations) do
          table.insert(anis, ani)
        end
        self.myUnFixComboType:SetData(anis, anis);
      end

    end
  end

  function PlayWithParams:_OnUnLink(unlinkPin)
    if self:_IsCompPin(unlinkPin) then
      self:_Reset();
    end
  end

  function PlayWithParams:_OnCreateWithEditor()
    PlayWithParams.super._OnCreateWithEditor(self);
    self:_SetupInstanceInfoTable();
  end

  function PlayWithParams:_OnUpdateByEditor()
    PlayWithParams.super._OnUpdateByEditor(self);
    self:_OnCompile();
  end

end

PlayWithParams:RegisterInput(1, AE.AnimationComponent:RTTI(), "target", "动画组件", BlueSelf());
PlayWithParams:RegisterInput(2, Types.ComboType, "ani" , "动画曲线", BD.EMPTY_STRING); -- 不能是空串
PlayWithParams:RegisterInput(3, Types.PlayType, "playType", "播放类型", AE.IComponent.PT_FORWARD);

PlayWithParams:RegisterExecInput(1, "exec", "Execute");
PlayWithParams:RegisterExecOutput(1, "exec", "Execute");

PlayWithParams:SetFunctionName("Ani Play With Params");

return PlayWithParams;
