local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local AE = require "apolloengine"

local StickerQuad = venuscore.VenusBehavior:extend("StickerQuad");
--2d/sticker_quad.shader材质一起使用  
--考虑到纹理是fbo  需要更新宽高比(编辑器时期的Game宽高与端内不一定一致)
--不在反射面板增加额外的逻辑 直接update修改双场景shader的参数保证不变形

function StickerQuad:new()

end


function StickerQuad:_OnAwake()

end

function StickerQuad:_OnUpdate(def)
    local renderCom = self.Node:GetComponent(AE.Node.CT_RENDER);
    if not renderCom then
        return;
    end
    local slotNameList, slot = renderCom:GetUniformParameter(1); --前景node只有一个matentity
    local entity = slot["_MainTex"];
    if entity:isTypeOrDriverType(AE.RenderTargetEntity:RTTI()) then
      entity = entity:GetAttachment(AE.RenderTargetEntity.TA_COLOR_0);
      imgSize = entity:GetSize();
    else
      imgSize = entity:GetSize();
    end
    if imgSize.mx/imgSize.my == slot["_TexAspect"] then
      return;
    end
    renderCom:SetParameter("_TexAspect", mathfunction.vector1(imgSize.mx/imgSize.my));
    
    if _KRATOSEDITOR then
        --解决编辑器的Game/Scene不一致
        --同步Scene场景
        local editSystem = require "window.editor.system.editsystem";
        local Command = require "window.editor.command.command";
        local editScene = editSystem:GetEditScene();
        local cmd = Command();
        cmd:SetSceneID(editScene:GetStaticID());
        local renderComScene =  cmd:GetContent(renderCom:GetContentPath());
        renderComScene:SetParameter("_TexAspect", mathfunction.vector1(imgSize.mx/imgSize.my));
    end
end





return StickerQuad;