require "utility"
local ae = require "apolloengine"
local vc = require "venuscore"
local mf = require "mathfunction"

local obj = {}


function obj:Initialize(host, size)

    self.order = 100

    self.TEXTURE_MASKING = ae.IMaterialSystem:NewParameterSlot(
            ae.ShaderEntity.UNIFORM,
            "TEXTURE_MASKING");

    self.material = host:CreateMaterial("comm:documents/material/masking.material");
    self.renderObject = host:CreateRenderObject();

    self:_InitializeParameters()

    self:_UpdateParameters()

    return self.order
end

function obj:Resizeview(size)
end

function obj:Process(context, Original, Scene, Output)

    self:_UpdateParameters()

    local colorClear = ae.RenderTargetEntity.CF_COLOR
    local color0 = ae.RenderTargetEntity.TA_COLOR_0

    self.material:SetParameter(
            ae.ShaderEntity.TEXTURE_DIFFUSE,
            Scene:GetAttachment(color0))


    context:BeginRenderPass(Output, colorClear);
    context:Draw(self.renderObject, self.material);
    context:EndRenderPass();
end

local function _CreateEmptyTexture()
    local tex = ae.TextureEntity()
    tex:PushMetadata(ae.TextureBufferMetadata(mf.vector2(4, 4)))
    tex:SetJobType(vc.IJob.JT_SYNCHRONOUS)
    tex:CreateResource()
    return tex
end

function obj:_InitializeParameters()

    self.maskingTexture = _CreateEmptyTexture()
    self.lastMaskingTexture = nil

end

function obj:_UpdateParameters()

    if self.lastMaskingTexture ~= self.maskingTexture then

        self.material:SetParameter(
                self.TEXTURE_MASKING,
                self.maskingTexture)

        self.lastMaskingTexture = self.maskingTexture
    end
end

return obj